/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.service.KeyStoreSpiPEMImpl;
import java.security.Provider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class KeyStoreProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "KeystoreService";
    private static final String DESCRIPTION = "Provider for keystores";
    private static final double VERSION = 1.0;
    private static final Map<String, String> SUPPORTED_KEYSTORE_TYPES = new HashMap<String, String>();

    static {
        SUPPORTED_KEYSTORE_TYPES.put("pem", KeyStoreSpiPEMImpl.class.getName());
    }

    public KeyStoreProvider() {
        super(NAME, 1.0, DESCRIPTION);
        for (String keystoreType : SUPPORTED_KEYSTORE_TYPES.keySet()) {
            this.setProperty("KeyStore." + keystoreType, SUPPORTED_KEYSTORE_TYPES.get(keystoreType));
        }
    }

    public static Set<String> getSupportedKeyStoreTypes() {
        return new TreeSet<String>(SUPPORTED_KEYSTORE_TYPES.keySet());
    }

    public static boolean isKeyStoreTypeSupported(String type) {
        if (type == null) {
            return false;
        }
        return SUPPORTED_KEYSTORE_TYPES.keySet().contains(type.toLowerCase(Locale.ENGLISH));
    }
}

