/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.service.pem.PEMObject;
import com.sap.cloud.crypto.keystore.service.pem.PEMParser;
import com.sap.cloud.crypto.keystore.service.pem.PEMReaderException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreSpiPEMImpl
extends KeyStoreSpi {
    private static final String ALIAS_PREFIX_CERTIFICATE = "certificate_";
    private static final String ALIAS_PREFIX_PRIVATEKEY = "privatekey_";
    private static final String ALIAS_PREFIX_KEYPAIR = "keypair_";
    private static final String ALIAS_PREFIX_PUBLICKEY = "publickey_";
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreSpiPEMImpl.class);
    private Map<String, PEMObject> content = new HashMap<String, PEMObject>();
    private Date loadTime;
    private byte[] rawContent;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PEMObject pemObject = this.content.get(alias);
        if (pemObject != null) {
            if (pemObject.getType() == PEMObject.Type.PrivateKey || pemObject.getType() == PEMObject.Type.Keypair) {
                return pemObject.getPrivateKey();
            }
            if (pemObject.getType() == PEMObject.Type.PublicKey) {
                return pemObject.getPublicKey();
            }
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        PEMObject pemObject = this.content.get(alias);
        if (pemObject != null && pemObject.getType() == PEMObject.Type.Keypair) {
            return pemObject.getChain();
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        PEMObject pemObject = this.content.get(alias);
        if (pemObject != null) {
            X509Certificate[] chain;
            if (pemObject.getType() == PEMObject.Type.Certificate) {
                return pemObject.getCertificate();
            }
            if (pemObject.getType() == PEMObject.Type.Keypair && (chain = pemObject.getChain()) != null && chain.length > 0) {
                return chain[0];
            }
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (this.content.containsKey(alias)) {
            return this.loadTime;
        }
        return null;
    }

    @Override
    public Enumeration<String> engineAliases() {
        return new Enumerator(this.content.keySet().iterator());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.content.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.content.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        PEMObject.Type type;
        PEMObject pemObject = this.content.get(alias);
        return pemObject != null && ((type = pemObject.getType()) == PEMObject.Type.PrivateKey || type == PEMObject.Type.Keypair || type == PEMObject.Type.PublicKey);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        PEMObject pemObject = this.content.get(alias);
        return pemObject != null && pemObject.getType() == PEMObject.Type.Certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert == null) {
            return null;
        }
        for (String alias : this.content.keySet()) {
            Certificate certToBeChecked = this.engineGetCertificate(alias);
            if (certToBeChecked == null || !certToBeChecked.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        List<PEMObject> parsedPEMObjects;
        this.rawContent = this.getStreamContent(stream);
        try {
            parsedPEMObjects = PEMParser.buildFromOrderedStream(new ByteArrayInputStream(this.rawContent));
            LOG.debug("PEM keystore parsed to the following entries: " + parsedPEMObjects);
        }
        catch (PEMReaderException e) {
            throw new IOException("Could not parse the given data as PEM keystore", e);
        }
        if (parsedPEMObjects != null) {
            int keyPairIndex = 1;
            int privateKeyIndex = 1;
            int certificateIndex = 1;
            int publicKeyIndex = 1;
            for (PEMObject pemObject : parsedPEMObjects) {
                if (pemObject == null) continue;
                switch (pemObject.getType()) {
                    case Keypair: {
                        this.content.put(ALIAS_PREFIX_KEYPAIR + keyPairIndex, pemObject);
                        ++keyPairIndex;
                        break;
                    }
                    case PrivateKey: {
                        this.content.put(ALIAS_PREFIX_PRIVATEKEY + privateKeyIndex, pemObject);
                        ++privateKeyIndex;
                        break;
                    }
                    case Certificate: {
                        this.content.put(ALIAS_PREFIX_CERTIFICATE + certificateIndex, pemObject);
                        ++certificateIndex;
                        break;
                    }
                    case PublicKey: {
                        this.content.put(ALIAS_PREFIX_PUBLICKEY + publicKeyIndex, pemObject);
                        ++publicKeyIndex;
                        break;
                    }
                }
            }
        }
        this.loadTime = new Date();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        stream.write(this.rawContent);
    }

    private byte[] getStreamContent(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int read = 0;
        byte[] bytes = new byte[4096];
        try {
            while ((read = is.read(bytes)) != -1) {
                bos.write(bytes, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            is.close();
            bos.close();
        }
    }

    private static final class Enumerator
    implements Enumeration<String> {
        private Iterator<String> iterator;

        private Enumerator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }
}

