/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.api.KeyStoreIllegalStateException;
import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.crypto.keystore.service.KeyStoreData;
import com.sap.cloud.crypto.keystore.service.KeyStoreExaminableStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class KeyStoreSpiWrapperImpl
extends KeyStoreSpi {
    private KeyStoreData keystoreData;
    private KeyStoreExaminableStorage examinableStorage;
    private char[] password;

    public KeyStoreSpiWrapperImpl(KeyStoreData keystoreData) {
        this.keystoreData = keystoreData;
    }

    public void setExaminableStorage(KeyStoreExaminableStorage examinableStorage) {
        this.examinableStorage = examinableStorage;
    }

    public boolean isExaminableStorage() {
        return this.examinableStorage != null;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public KeyStoreData getKeystoreData() {
        return this.keystoreData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getWrappedKeyStore() throws KeyStoreIllegalStateException {
        if (this.examinableStorage != null) {
            KeyStoreSpiWrapperImpl keyStoreSpiWrapperImpl = this;
            synchronized (keyStoreSpiWrapperImpl) {
                if (this.examinableStorage.isKeyStoreChanged(this.keystoreData.getName(), this.keystoreData.getKeyStoreTypeProvidedByStorage(), this.keystoreData.getVersionStamp())) {
                    try {
                        KeyStoreData tempData = this.examinableStorage.getKeyStore(this.keystoreData.getName());
                        if (tempData == null) {
                            throw new KeyStoreIllegalStateException("Keystore with name: " + this.keystoreData.getName() + " no longer exists and cannot be re-read");
                        }
                        this.keystoreData = tempData;
                        this.keystoreData.load(this.password);
                    }
                    catch (KeyStoreServiceException e) {
                        throw new KeyStoreIllegalStateException("Keystore with name: " + this.keystoreData.getName() + " is changed, but cannot be re-read", (Throwable)e);
                    }
                }
            }
        }
        return this.keystoreData.getKeyStore();
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter param) throws NoSuchAlgorithmException, UnrecoverableEntryException {
        try {
            return this.getWrappedKeyStore().getEntry(alias, param);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.getWrappedKeyStore().getKey(alias, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.getWrappedKeyStore().getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            return this.getWrappedKeyStore().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        try {
            return this.getWrappedKeyStore().getCreationDate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        try {
            return this.getWrappedKeyStore().aliases();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        try {
            return this.getWrappedKeyStore().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public int engineSize() {
        try {
            return this.getWrappedKeyStore().size();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            return this.getWrappedKeyStore().isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.getWrappedKeyStore().isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.getWrappedKeyStore().getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entry) {
        try {
            return this.getWrappedKeyStore().entryInstanceOf(alias, entry);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Internal keystore is not loaded: " + this.keystoreData, e);
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter parameter) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.keystoreData.getKeyStore().store(stream, password);
        }
        catch (KeyStoreException e) {
            throw new IOException("Exception thrwon while trying to call KeyStore.store of the wrapped keystore object", e);
        }
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetEntry(String arg0, KeyStore.Entry arg1, KeyStore.ProtectionParameter arg2) throws KeyStoreException {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
    }
}

