/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.api.KeyStoreNotFoundException;
import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.crypto.keystore.service.ClientSideKeyStore;
import com.sap.cloud.crypto.keystore.service.ConfigurationUtil;
import com.sap.cloud.crypto.keystore.service.KeyStoreData;
import com.sap.cloud.crypto.keystore.service.KeyStoreDomainDBReadException;
import com.sap.cloud.crypto.keystore.service.KeyStoreDomainDBStorage;
import com.sap.cloud.crypto.keystore.service.KeyStoreExaminableStorage;
import com.sap.cloud.crypto.keystore.service.KeyStoreFileStorage;
import com.sap.cloud.crypto.keystore.service.KeyStoreSpiWrapperImpl;
import com.sap.cloud.crypto.keystore.service.KeyStoreStorage;
import com.sap.cloud.crypto.keystore.service.cache.CacheValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreValueReader
implements CacheValueReader<ClientSideKeyStore> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreValueReader.class);
    private String tenantID;

    public KeyStoreValueReader(String tenantID) {
        this.tenantID = tenantID;
    }

    @Override
    public ClientSideKeyStore readValue(String key, ClientSideKeyStore currentValue) throws Exception {
        KeyStoreData keystoreData = null;
        KeyStoreStorage storage = null;
        boolean cloudStorageAvailable = this.isCloudStorageAvailable();
        try {
            if (cloudStorageAvailable && (keystoreData = (storage = this.getKeyStoreCloudStorage(this.tenantID)).getKeyStore(key)) != null && LOG.isDebugEnabled()) {
                LOG.debug("Loaded keystore from cloud (domain DB) storage: " + keystoreData);
            }
            if (keystoreData == null && (keystoreData = (storage = this.getKeyStoreLocalStorage()).getKeyStore(key)) != null && LOG.isDebugEnabled()) {
                LOG.debug("Loaded keystore from local (file) storage: " + keystoreData);
            }
            if (keystoreData == null) {
                String errorMessage = cloudStorageAvailable ? "Keystore with name: '" + key + "', for tenant: '" + this.tenantID + "' is not found neither in the cloud (domain db) nor in the local (file) storage" : "Keystore with name: '" + key + "' is not found in the local (file) storage";
                throw new KeyStoreNotFoundException(errorMessage);
            }
            if (currentValue != null && keystoreData.getVersionStamp() == currentValue.getVersionStamp()) {
                return currentValue;
            }
            KeyStoreSpiWrapperImpl keyStoreSpi = new KeyStoreSpiWrapperImpl(keystoreData);
            if (storage instanceof KeyStoreExaminableStorage) {
                keyStoreSpi.setExaminableStorage((KeyStoreExaminableStorage)storage);
            }
            return new ClientSideKeyStore(keyStoreSpi, keystoreData.getKeyStore().getProvider(), keystoreData.getKeyStore().getType());
        }
        catch (KeyStoreDomainDBReadException e) {
            LOG.warn("KeyStoreDomainDBReadException occured while trying to read keystore with name: '" + key + "', for tenant: '" + this.tenantID + "' from the cloud (domain db). Currently cached value will be used.", (Throwable)((Object)e));
            return currentValue;
        }
        catch (KeyStoreServiceException e) {
            LOG.error("Keystore with name: '" + key + "', for tenant: '" + this.tenantID + "' is not found neither in the cloud (domain db) nor in the local (file) storage", (Throwable)e);
            throw e;
        }
    }

    private KeyStoreStorage getKeyStoreLocalStorage() {
        return new KeyStoreFileStorage();
    }

    private KeyStoreStorage getKeyStoreCloudStorage(String tenantID) {
        return new KeyStoreDomainDBStorage(tenantID);
    }

    private boolean isCloudStorageAvailable() {
        return ConfigurationUtil.isDomainDBAvailable();
    }
}

