/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service;

import com.sap.cloud.crypto.keystore.service.properties.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TenantProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TenantProvider.class);
    private final TenantSource tenantSource;
    private final String tenantName;

    private TenantProvider(TenantSource tenantSource, String tenantName) {
        this.tenantSource = tenantSource;
        this.tenantName = tenantName;
    }

    public static TenantProvider forPredefinedTenantName(String tenantName) {
        return new TenantProvider(TenantSource.PREDEFINED_TENANT, tenantName);
    }

    public static TenantProvider forDynamicTenantForThread() {
        return new TenantProvider(TenantSource.DYNAMIC_TENANT_FOR_THREAD, null);
    }

    public String getTenantName() {
        switch (this.tenantSource) {
            case DYNAMIC_TENANT_FOR_THREAD: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returning dynamically calculated tenant: {}", (Object)PropertiesManager.getInstance().getTenantId());
                }
                return PropertiesManager.getInstance().getTenantId();
            }
            case PREDEFINED_TENANT: {
                LOG.debug("Returning predefined tenant: {}", (Object)this.tenantName);
                return this.tenantName;
            }
        }
        throw new IllegalStateException(this.tenantSource.toString());
    }

    static enum TenantSource {
        PREDEFINED_TENANT,
        DYNAMIC_TENANT_FOR_THREAD;

    }
}

