/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.asn1;

import com.sap.cloud.crypto.keystore.service.asn1.DEROutputStream;
import java.io.IOException;

public abstract class ASN1BaseType {
    private int type;
    private boolean complexType;

    protected ASN1BaseType(int type) {
        this(type, false);
    }

    protected ASN1BaseType(int type, boolean complexType) {
        this.type = type;
        this.complexType = complexType;
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    public boolean isComplexType() {
        return this.complexType;
    }

    public void setComplexType(boolean complexType) {
        this.complexType = complexType;
    }

    protected abstract void encodeBody(DEROutputStream var1) throws IOException;

    public final void encodeToDER(DEROutputStream output) throws IOException {
        int initialSize = output.size();
        this.encodeBody(output);
        int length = output.size() - initialSize;
        if (length < 128) {
            output.write(length);
        } else {
            output.write(length % 256);
            int numberOfLengthOctets = 1;
            length >>>= 8;
            while (length > 0) {
                output.write(length % 256);
                ++numberOfLengthOctets;
                length >>>= 8;
            }
            output.write(0x80 | numberOfLengthOctets);
        }
        if (this.complexType) {
            output.write(this.type | 0x20);
        } else {
            output.write(this.type);
        }
    }
}

