/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.asn1;

import com.sap.cloud.crypto.keystore.service.asn1.ASN1BaseType;
import com.sap.cloud.crypto.keystore.service.asn1.DEROutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ASN1CompositeType
extends ASN1BaseType {
    private List<ASN1BaseType> subElements = new ArrayList<ASN1BaseType>();

    public ASN1CompositeType(int type) {
        super(type, true);
    }

    @Override
    protected void encodeBody(DEROutputStream output) throws IOException {
        ArrayList<ASN1BaseType> tempList = new ArrayList<ASN1BaseType>(this.subElements);
        Collections.reverse(tempList);
        for (ASN1BaseType asn1BaseType : tempList) {
            asn1BaseType.encodeToDER(output);
        }
    }

    public void addSubElement(ASN1BaseType subElement) {
        this.subElements.add(subElement);
    }

    public void addSubElements(List<ASN1BaseType> subElements) {
        this.subElements.addAll(subElements);
    }
}

