/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.asn1;

import com.sap.cloud.crypto.keystore.service.asn1.ASN1BaseType;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Sequence;
import com.sap.cloud.crypto.keystore.service.asn1.DEROutputStream;
import java.io.IOException;

public class ASN1ContextSpecificTag
extends ASN1BaseType {
    private ASN1BaseType content;

    public ASN1ContextSpecificTag(int tag, ASN1BaseType asn1Element, boolean implicit) {
        super(ASN1ContextSpecificTag.calculateType(tag));
        if (implicit) {
            this.content = asn1Element;
            super.setComplexType(asn1Element.isComplexType());
        } else {
            this.content = new ASN1Sequence();
            ((ASN1Sequence)this.content).addSubElement(asn1Element);
            super.setComplexType(true);
        }
    }

    private static int calculateType(int tag) {
        if (tag < 0 || tag > 30) {
            throw new IllegalArgumentException("Invalid tag value: " + tag + ". Tag must be between 0 and 30");
        }
        int result = 0x80 | (tag &= 0x1F);
        return result;
    }

    @Override
    protected void encodeBody(DEROutputStream output) throws IOException {
        this.content.encodeBody(output);
    }
}

