/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.asn1;

import com.sap.cloud.crypto.keystore.service.asn1.DERInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ASN1Parser {
    public static List<BigInteger> parseSequenceOfIntegers(byte[] asn1Body) throws IOException {
        ArrayList<BigInteger> result = new ArrayList<BigInteger>();
        DERInputStream asn1Stream = new DERInputStream(asn1Body);
        byte[] sequenceType = asn1Stream.read(1L);
        if (sequenceType[0] != 48) {
            throw new IOException("invalid ASN1 structure - not a SEQUENCE");
        }
        byte[] lengthFirstByte = asn1Stream.read(1L);
        long sequenceLength = ASN1Parser.extractLength(asn1Stream, lengthFirstByte);
        if (sequenceLength < 1L) {
            throw new IOException("invalid ASN1 SEQUENCE - invalid body length: " + sequenceLength);
        }
        byte[] sequenceBody = asn1Stream.read(sequenceLength);
        DERInputStream sequenceStream = new DERInputStream(sequenceBody);
        do {
            result.add(ASN1Parser.parseASN1Integer(sequenceStream));
        } while (!sequenceStream.isConsumed());
        return result;
    }

    private static BigInteger parseASN1Integer(DERInputStream sequenceStream) throws IOException {
        BigInteger result = null;
        byte[] asn1Type = sequenceStream.read(1L);
        if (asn1Type[0] != 2) {
            throw new IOException("invalid ASN1 structure - not an INTEGER");
        }
        byte[] lengthFirstByte = sequenceStream.read(1L);
        long integerLength = ASN1Parser.extractLength(sequenceStream, lengthFirstByte);
        if (integerLength < 1L) {
            throw new IOException("invalid ASN1 INTEGER - invalid body length: " + integerLength);
        }
        byte[] integerBody = sequenceStream.read(integerLength);
        result = new BigInteger(integerBody);
        return result;
    }

    private static long extractLength(DERInputStream input, byte[] lengthFirstByte) throws IOException {
        long result;
        if ((lengthFirstByte[0] & 0x80) == 0) {
            result = lengthFirstByte[0];
        } else {
            int countOfLengthBytes = lengthFirstByte[0] & 0x7F;
            if (countOfLengthBytes < 1) {
                throw new IOException("invalid ASN1 structure - bad ASN1Object length: " + countOfLengthBytes);
            }
            byte[] lengthRecord = input.read(countOfLengthBytes);
            result = new BigInteger(1, lengthRecord).longValue();
        }
        return result;
    }
}

