/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.asn1;

import com.sap.cloud.crypto.keystore.service.asn1.ASN1BaseType;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Constants;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1EncodedType;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Integer;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1ObjectID;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Sequence;
import com.sap.cloud.crypto.keystore.service.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class ASN1Utils {
    private static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final String UTC_DATE_FORMAT = "yyMMddHHmmss'Z'";

    public static final byte[] encodeDER(ASN1BaseType asn1) throws IOException {
        DEROutputStream output = new DEROutputStream();
        asn1.encodeToDER(output);
        return output.toByteArray();
    }

    public static final ASN1BaseType extractIssuerAndSerial(X509Certificate certificate) {
        ASN1Sequence result = new ASN1Sequence();
        byte[] issuer = certificate.getIssuerX500Principal().getEncoded();
        result.addSubElement(new ASN1EncodedType(issuer));
        result.addSubElement(new ASN1Integer(certificate.getSerialNumber()));
        return result;
    }

    public static final void writeInReverseOrder(byte[] data, ByteArrayOutputStream destination) {
        int i = data.length - 1;
        while (i >= 0) {
            destination.write(data[i]);
            --i;
        }
    }

    public static final ASN1BaseType getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(UTC_DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(TIME_ZONE_GMT);
        final String date = dateFormat.format(new Date());
        ASN1BaseType result = new ASN1BaseType(23){

            @Override
            protected void encodeBody(DEROutputStream output) throws IOException {
                ASN1Utils.writeInReverseOrder(date.getBytes("ISO8859_1"), output);
            }
        };
        return result;
    }

    public static final ASN1BaseType createAlgorithmIdentifier(String objectID) {
        ASN1Sequence sequence = new ASN1Sequence();
        ASN1ObjectID asn1ObjectID = new ASN1ObjectID(objectID);
        sequence.addSubElement(asn1ObjectID);
        sequence.addSubElement(ASN1Constants.ASN1_NULL_INSTANCE);
        return sequence;
    }
}

