/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.asn1;

import java.io.IOException;
import java.util.Arrays;

public class DERInputStream {
    private byte[] body;
    private int position = 0;

    public DERInputStream(byte[] body) {
        this.body = body;
    }

    public synchronized byte[] read(long length) throws IOException {
        if ((long)this.body.length < (long)this.position + length) {
            throw new IOException("invalid ASN1 structure - not enough bytes to read");
        }
        byte[] result = Arrays.copyOfRange(this.body, this.position, this.position + (int)length);
        this.position = (int)((long)this.position + length);
        return result;
    }

    public synchronized boolean isConsumed() {
        return this.position >= this.body.length;
    }
}

