/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.cache;

import com.sap.cloud.crypto.keystore.service.cache.CacheConfiguration;
import com.sap.cloud.crypto.keystore.service.cache.CacheEntry;
import com.sap.cloud.crypto.keystore.service.cache.CacheValueReader;
import java.util.HashMap;
import java.util.Map;

public class Cache<T>
implements CacheConfiguration {
    private CacheValueReader<T> valueReader;
    private long valueTimeout;
    private long lastAccessTimeout;
    private Map<String, CacheEntry<T>> cacheEntries = new HashMap<String, CacheEntry<T>>();

    public Cache(CacheValueReader<T> valueReader, long valueTimeout, long lastAccessTimeout) {
        this.valueReader = valueReader;
        this.valueTimeout = valueTimeout;
        this.lastAccessTimeout = lastAccessTimeout;
    }

    @Override
    public long getValueTimeout() {
        return this.valueTimeout;
    }

    public void setValueTimeout(long valueTimeout) {
        this.valueTimeout = valueTimeout;
    }

    @Override
    public long getLastAccessTimeout() {
        return this.lastAccessTimeout;
    }

    public void setLastAccessTimeout(long lastAccessTimeout) {
        this.lastAccessTimeout = lastAccessTimeout;
    }

    public synchronized CacheEntry<T> getCacheEntry(String key) {
        CacheEntry<T> entry = null;
        entry = this.cacheEntries.get(key);
        if (entry == null) {
            entry = new CacheEntry<T>(this, key, this.valueReader);
            this.cacheEntries.put(key, entry);
        }
        return entry;
    }

    public synchronized CacheEntry<T> removeEntry(String key) {
        return this.cacheEntries.remove(key);
    }
}

