/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.cache;

import com.sap.cloud.crypto.keystore.service.cache.CacheConfiguration;
import com.sap.cloud.crypto.keystore.service.cache.CacheValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntry<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheEntry.class);
    private CacheValueReader<T> valueReader;
    private String key;
    private T value;
    private long valueTimestamp;
    private long lastAccessTimestamp;
    private boolean updateTriggered = false;
    private CacheConfiguration tenantCacheConfig;

    public CacheEntry(CacheConfiguration tenantCacheConfig, String key, CacheValueReader<T> valueReader) {
        this.key = key;
        this.valueReader = valueReader;
        this.tenantCacheConfig = tenantCacheConfig;
    }

    public synchronized T getValue() throws Exception {
        long currentTime = System.currentTimeMillis();
        T returnValue = this.value;
        if (!this.updateTriggered && currentTime - this.valueTimestamp >= this.tenantCacheConfig.getValueTimeout()) {
            if (currentTime - this.lastAccessTimestamp >= this.tenantCacheConfig.getLastAccessTimeout()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Triggering synchronous cache update for key [" + this.key + "].");
                }
                this.readValue();
                returnValue = this.value;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Triggering asynchronous cache update for key [" + this.key + "].");
                }
                this.updateTriggered = true;
                returnValue = this.value;
                Thread thread = new Thread(this);
                thread.setName("Asynchronous cache update for: " + this.key);
                thread.start();
            }
        }
        this.lastAccessTimestamp = currentTime;
        return returnValue;
    }

    private void readValue() throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting cache update for key [" + this.key + "] using value reader [" + this.valueReader.getClass().getSimpleName() + "].");
            }
            try {
                this.value = this.valueReader.readValue(this.key, this.value);
            }
            catch (Exception e) {
                LOG.error("Exception occured while trying to update the cache for key [" + this.key + "] using value reader [" + this.valueReader.getClass().getSimpleName() + "].", (Throwable)e);
                this.value = null;
                this.valueTimestamp = 0L;
                throw e;
            }
            this.valueTimestamp = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successful cache update for key [" + this.key + "] using value reader [" + this.valueReader.getClass().getSimpleName() + "].");
            }
        }
        finally {
            this.updateTriggered = false;
        }
    }

    @Override
    public void run() {
        try {
            this.readValue();
        }
        catch (Exception e) {
            LOG.error("Exception durring asynchronous cache update: " + e.getMessage(), (Throwable)e);
        }
    }
}

