/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.lifecycle;

import com.sap.cloud.crypto.keystore.service.lifecycle.KeystoreProviderRegistration;
import com.sap.cloud.crypto.keystore.service.properties.PropertiesManager;
import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreLifecycle
implements InternalComponentLifecycle {
    private static final String CONFIG_FILE_PATH = String.valueOf(System.getProperty("server.config.home", ".")) + File.separator + "config_master" + File.separator + "com.sap.cloud.crypto.keystore" + File.separator + "keystore_cfg.props";
    private static final Logger LOG = LoggerFactory.getLogger(KeystoreLifecycle.class);

    public void start() {
        KeystoreProviderRegistration.getInstance().registerKeystoreProvider();
        LOG.info("Starting the keystore service");
        File configFile = new File(CONFIG_FILE_PATH);
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(configFile));
        }
        catch (IOException iOException) {
            LOG.error("Failed to load properties from configuration path {}. Configuration file exists: {}", (Object)CONFIG_FILE_PATH, (Object)configFile.exists());
            throw new RuntimeException("Failed to initialize keystore service");
        }
        LOG.info("Updating service configuration with properties: {}", (Object)props);
        PropertiesManager.getInstance().updateProperties(props);
    }

    public void stop() {
        LOG.info("Stopping the keystore service");
        KeystoreProviderRegistration.getInstance().unregisterKeystoreProvider();
    }
}

