/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.lifecycle;

import com.sap.cloud.crypto.keystore.service.KeyStoreProvider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreProviderRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(KeystoreProviderRegistration.class);
    private static KeystoreProviderRegistration INSTANCE;
    private KeyStoreProvider keystoreProvider;

    private KeystoreProviderRegistration() {
    }

    public static synchronized KeystoreProviderRegistration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeystoreProviderRegistration();
        }
        return INSTANCE;
    }

    public void registerKeystoreProvider() {
        this.keystoreProvider = new KeyStoreProvider();
        Security.addProvider(this.keystoreProvider);
        if (LOG.isDebugEnabled()) {
            LOG.debug("KeyStoreProvider registered as security provider");
        }
    }

    public void unregisterKeystoreProvider() {
        if (this.keystoreProvider != null) {
            Security.removeProvider(this.keystoreProvider.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("KeyStoreProvider unregistered as security provider");
            }
            this.keystoreProvider = null;
        }
    }
}

