/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.osgi;

import com.sap.cloud.crypto.keystore.api.KeyStoreService;
import com.sap.cloud.crypto.keystore.service.DefaultKeyStoreServiceProvider;
import com.sap.cloud.crypto.keystore.service.KeyStoreServiceImpl;
import com.sap.cloud.crypto.keystore.service.ext.KeyStoreServiceExt;
import com.sap.cloud.crypto.keystore.service.lifecycle.KeystoreProviderRegistration;
import com.sap.cloud.crypto.keystore.service.osgi.KeyStoreServiceAccessorOSGI;
import com.sap.cloud.crypto.keystore.service.properties.PropertiesManager;
import com.sap.cloud.crypto.keystore.service.provider.KeyStoreServiceProvider;
import com.sap.core.connectivity.httpdestination.internal.api.ISystemDestinationsService;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreManagedService
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreManagedService.class);
    private ServiceRegistration<?> keyStoreServiceRegistration;
    private ServiceRegistration<?> keyStoreServiceProviderRegistration;

    protected void activate(ComponentContext componentContext) {
        ConfigurationAdmin configAdmin;
        BundleContext context = componentContext.getBundleContext();
        KeystoreProviderRegistration.getInstance().registerKeystoreProvider();
        KeyStoreServiceImpl keyStoreService = new KeyStoreServiceImpl();
        this.keyStoreServiceRegistration = context.registerService(new String[]{KeyStoreService.class.getName(), KeyStoreServiceExt.class.getName()}, (Object)keyStoreService, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("KeyStoreService registered as OSGi service.");
        }
        DefaultKeyStoreServiceProvider keyStoreServiceProvider = new DefaultKeyStoreServiceProvider();
        this.keyStoreServiceProviderRegistration = context.registerService(new String[]{KeyStoreServiceProvider.class.getName()}, (Object)keyStoreServiceProvider, null);
        LOG.info("KeyStoreServiceProvider registered as OSGi service.");
        ServiceReference reference = context.getServiceReference(ConfigurationAdmin.class);
        if (reference != null && (configAdmin = (ConfigurationAdmin)context.getService(reference)) != null) {
            try {
                Configuration keystoreConfiguration = configAdmin.getConfiguration(KeyStoreManagedService.class.getName());
                if (keystoreConfiguration != null) {
                    PropertiesManager.getInstance().updateProperties(keystoreConfiguration.getProperties());
                }
            }
            catch (Exception e) {
                LOG.error("Error reading keystore management configuration", (Throwable)e);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.keyStoreServiceRegistration != null) {
            this.keyStoreServiceRegistration.unregister();
            this.keyStoreServiceRegistration = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("KeyStoreService is unregistered");
            }
        }
        if (this.keyStoreServiceProviderRegistration != null) {
            this.keyStoreServiceProviderRegistration.unregister();
            this.keyStoreServiceProviderRegistration = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("KeyStoreServiceProvider is unregistered");
            }
        }
        KeystoreProviderRegistration.getInstance().unregisterKeystoreProvider();
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        PropertiesManager.getInstance().updateProperties(properties);
    }

    protected void setSystemDestinationsService(ISystemDestinationsService systemDestinationsService) {
        KeyStoreServiceAccessorOSGI.setSystemDestinationsService(systemDestinationsService);
    }

    protected void unsetSystemDestinationsService(ISystemDestinationsService systemDestinationsService) {
        KeyStoreServiceAccessorOSGI.setSystemDestinationsService(null);
    }
}

