/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.pem;

import com.sap.cloud.crypto.keystore.service.pem.KeypairBuilderException;
import com.sap.cloud.crypto.keystore.service.pem.PEMObject;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class KeypairBuilder {
    private static final byte[] RAW_DATA_TO_SIGN;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        RAW_DATA_TO_SIGN = byArray;
    }

    public static List<PEMObject> buildFromOrderedStream(List<PEMObject> rawPEMContent) throws KeypairBuilderException {
        if (rawPEMContent.size() == 0) {
            return rawPEMContent;
        }
        ArrayList<PEMObject> result = new ArrayList<PEMObject>();
        int i = 0;
        ArrayList<X509Certificate> trustChain = new ArrayList<X509Certificate>();
        while (i < rawPEMContent.size()) {
            PEMObject ownCertEntry;
            PEMObject current = rawPEMContent.get(i);
            if (current.getType() == PEMObject.Type.PrivateKey && (ownCertEntry = KeypairBuilder.getOwnCert(rawPEMContent, i)) != null) {
                current.setType(PEMObject.Type.Keypair);
                trustChain.clear();
                trustChain.add(ownCertEntry.getCertificate());
                int j = KeypairBuilder.getChain(rawPEMContent, ++i + 1, trustChain);
                current.setChain(trustChain.toArray(new X509Certificate[trustChain.size()]));
                i += j;
            }
            result.add(current);
            ++i;
        }
        return result;
    }

    private static int getChain(List<PEMObject> rawPEMContent, int currentPosition, List<X509Certificate> trustChain) {
        int chainLenght = 0;
        while (currentPosition + chainLenght < rawPEMContent.size()) {
            PEMObject next = rawPEMContent.get(currentPosition + chainLenght);
            if (next.getType() != PEMObject.Type.Certificate || !KeypairBuilder.isSignedBy(trustChain.get(trustChain.size() - 1), next.getCertificate())) break;
            ++chainLenght;
            trustChain.add(next.getCertificate());
        }
        return chainLenght;
    }

    private static PEMObject getOwnCert(List<PEMObject> rawPEMContent, int currentPosition) {
        PEMObject possibleCert;
        if (currentPosition + 1 < rawPEMContent.size() && (possibleCert = rawPEMContent.get(currentPosition + 1)).getType() == PEMObject.Type.Certificate && KeypairBuilder.isKeyPair(rawPEMContent.get(currentPosition).getPrivateKey(), possibleCert.getCertificate())) {
            return possibleCert;
        }
        return null;
    }

    public static boolean isSignedBy(X509Certificate oneCertificate, X509Certificate issuer) {
        if (oneCertificate.equals(issuer)) {
            return false;
        }
        if (!oneCertificate.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) {
            return false;
        }
        try {
            oneCertificate.verify(issuer.getPublicKey());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isKeyPair(PrivateKey onePrivateKey, X509Certificate oneCertificate) {
        try {
            Signature signature = null;
            signature = onePrivateKey.getAlgorithm().equals("DSA") ? Signature.getInstance("DSA") : Signature.getInstance("MD5WithRSA");
            signature.initSign(onePrivateKey);
            signature.update(RAW_DATA_TO_SIGN);
            byte[] signed = signature.sign();
            signature.initVerify(oneCertificate.getPublicKey());
            signature.update(RAW_DATA_TO_SIGN);
            return signature.verify(signed);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

