/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.pem;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class PEMObject {
    private Type type;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private X509Certificate certificate;
    private X509Certificate[] chain;

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate[] getChain() {
        return Arrays.copyOf(this.chain, this.chain.length);
    }

    public void setChain(X509Certificate[] chain) {
        this.chain = chain;
    }

    public String toString() {
        StringBuilder temp = new StringBuilder();
        temp.append("PEM Object {").append("\r\n");
        temp.append(" type       : ").append((Object)this.type).append("\r\n");
        temp.append(" public  key: ").append(this.publicKey != null ? String.valueOf(this.publicKey.getAlgorithm()) + "/" + this.publicKey.getFormat() : "nul").append("\r\n");
        temp.append(" private key: ").append(this.privateKey != null ? String.valueOf(this.privateKey.getAlgorithm()) + "/" + this.privateKey.getFormat() : "nul").append("\r\n");
        temp.append(" certificate: ").append(this.certificate != null ? this.certificate.getSubjectX500Principal() + " // " + this.certificate.getIssuerX500Principal() : "nul").append("\r\n");
        temp.append(" chain      : ").append(this.chain != null ? Integer.valueOf(this.chain.length) : "nul").append("\r\n");
        temp.append("}").append("\r\n");
        return temp.toString();
    }

    public static enum Type {
        PrivateKey,
        Certificate,
        PublicKey,
        Keypair;

    }
}

