/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.pem;

import com.sap.cloud.crypto.keystore.service.asn1.ASN1Constants;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Integer;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1ObjectID;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1OctetString;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Parser;
import com.sap.cloud.crypto.keystore.service.asn1.ASN1Sequence;
import com.sap.cloud.crypto.keystore.service.asn1.DEROutputStream;
import com.sap.cloud.crypto.keystore.service.pem.PEMObject;
import com.sap.cloud.crypto.keystore.service.pem.PEMReaderException;
import com.sap.core.jpaas.security.utils.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PEMReader {
    private static final Logger LOG = LoggerFactory.getLogger(PEMReader.class);

    public static List<PEMObject> readPEM(InputStream is) throws PEMReaderException {
        ArrayList<PEMObject> result;
        try {
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            result = new ArrayList<PEMObject>();
            ArrayList<String> lines = new ArrayList<String>(10);
            String oneLine = null;
            while ((oneLine = lineReader.readLine()) != null) {
                lines.add(oneLine);
            }
            Iterator<String> iter = lines.iterator();
            String currentLine = null;
            PEMObject pemObject = null;
            while (iter.hasNext()) {
                currentLine = (String)iter.next();
                if (!currentLine.startsWith("-----BEGIN")) continue;
                try {
                    pemObject = PEMReader.readPEMObject(iter, currentLine);
                    result.add(pemObject);
                }
                catch (Exception _) {
                    LOG.warn("Skiped PEM type: " + currentLine, (Throwable)_);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new PEMReaderException("Failed to read the stream using UTF-8 charset: ", e);
        }
        catch (IOException e) {
            throw new PEMReaderException("Failed to read the stream: ", e);
        }
        return result;
    }

    private static PEMObject readPEMObject(Iterator<String> iter, String BEGIN_LINE) throws PEMReaderException {
        String END_LINE = "-----END" + BEGIN_LINE.substring(10);
        String OBJECT_TYPE = BEGIN_LINE.substring(10, BEGIN_LINE.lastIndexOf("-----")).trim();
        ArrayList<String> body = new ArrayList<String>(10);
        String bodyLine = null;
        while (iter.hasNext() && !END_LINE.equals(bodyLine = iter.next())) {
            body.add(bodyLine);
        }
        if (!END_LINE.equals(bodyLine)) {
            throw new PEMReaderException("Bad PEM file - missing closing line for: " + BEGIN_LINE);
        }
        if (OBJECT_TYPE.endsWith("PRIVATE KEY")) {
            return PEMReader.parsePrivateKey(body, OBJECT_TYPE);
        }
        if (OBJECT_TYPE.endsWith("PUBLIC KEY")) {
            return PEMReader.parsePublicKey(body, OBJECT_TYPE);
        }
        if (OBJECT_TYPE.endsWith("CERTIFICATE")) {
            return PEMReader.parseCertificate(body, OBJECT_TYPE);
        }
        throw new PEMReaderException("Unknown PEM type: " + OBJECT_TYPE);
    }

    private static byte[] getBytes(List<String> body) throws PEMReaderException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(65 * body.size());
            for (String line : body) {
                baos.write(Base64.decode((String)line));
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new PEMReaderException("Failed to base64 decode: ", e);
        }
    }

    private static Properties removeHeaders(List<String> body) {
        Properties headers = new Properties();
        String line = null;
        int index = -1;
        while (body.size() > 0 && (index = (line = body.get(0)).indexOf(":")) != -1) {
            headers.setProperty(line.substring(0, index).trim(), line.substring(index + 1).trim());
            body.remove(0);
        }
        return headers;
    }

    private static PEMObject parseCertificate(List<String> body, String object_type) throws PEMReaderException {
        PEMObject result;
        byte[] bytes = PEMReader.getBytes(body);
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
            CertificateFactory x509 = CertificateFactory.getInstance("X509");
            result = new PEMObject();
            result.setType(PEMObject.Type.Certificate);
            result.setCertificate((X509Certificate)x509.generateCertificate(inStream));
        }
        catch (CertificateException e) {
            throw new PEMReaderException("Failed to parse x509 certificate: ", e);
        }
        return result;
    }

    private static PEMObject parsePublicKey(List<String> body, String object_type) throws PEMReaderException {
        byte[] bytes = PEMReader.getBytes(body);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
        PEMObject result = new PEMObject();
        result.setType(PEMObject.Type.PublicKey);
        try {
            try {
                KeyFactory kf = KeyFactory.getInstance("RSA");
                result.setPublicKey(kf.generatePublic(spec));
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                KeyFactory kf = KeyFactory.getInstance("DSA");
                result.setPublicKey(kf.generatePublic(spec));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PEMReaderException("failed to generate public key for type '" + object_type + "' ", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PEMReaderException("failed to generate public key for type '" + object_type + "' ", e);
        }
        return result;
    }

    private static PEMObject parsePrivateKey(List<String> body, String object_type) throws PEMReaderException {
        Properties headers = PEMReader.removeHeaders(body);
        if (headers.size() != 0) {
            throw new PEMReaderException("encrypted private keys are not supported.");
        }
        byte[] bytes = PEMReader.getBytes(body);
        if (object_type.equals("RSA PRIVATE KEY")) {
            return PEMReader.parseRSAPrivateKey(bytes);
        }
        return PEMReader.parseDSAPrivateKey(bytes);
    }

    private static final PEMObject parseRSAPrivateKey(byte[] bytes) throws PEMReaderException {
        ASN1Sequence wrapper = new ASN1Sequence();
        wrapper.addSubElement(new ASN1Integer(0L));
        ASN1Sequence algId = new ASN1Sequence();
        algId.addSubElement(new ASN1ObjectID("1.2.840.113549.1.1.1"));
        algId.addSubElement(ASN1Constants.ASN1_NULL_INSTANCE);
        wrapper.addSubElement(algId);
        wrapper.addSubElement(new ASN1OctetString(bytes));
        DEROutputStream out = new DEROutputStream();
        try {
            wrapper.encodeToDER(out);
        }
        catch (IOException e) {
            throw new PEMReaderException("ASN1 wrapper failed", e);
        }
        bytes = out.toByteArray();
        PEMObject result = new PEMObject();
        result.setType(PEMObject.Type.PrivateKey);
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            result.setPrivateKey(kf.generatePrivate(spec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new PEMReaderException("failed to generate RSA private key.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PEMReaderException("failed to generate RSA private key.", e);
        }
        return result;
    }

    private static final PEMObject parseDSAPrivateKey(byte[] bytes) throws PEMReaderException {
        List<BigInteger> integers;
        try {
            integers = ASN1Parser.parseSequenceOfIntegers(bytes);
            if (integers.size() != 6) {
                throw new PEMReaderException("Could not parse the given input as PEM DSA private key - expected 6 ASN1 INTEGER objects but received " + integers.size());
            }
        }
        catch (IOException e1) {
            throw new PEMReaderException("Could not parse the given input as PEM DSA private key: ", e1);
        }
        try {
            ASN1Sequence wrapper = new ASN1Sequence();
            wrapper.addSubElement(new ASN1Integer(integers.get(0)));
            ASN1Sequence internalSequence = new ASN1Sequence();
            internalSequence.addSubElement(new ASN1ObjectID("1.2.840.10040.4.1"));
            ASN1Sequence againSequence = new ASN1Sequence();
            againSequence.addSubElement(new ASN1Integer(integers.get(1)));
            againSequence.addSubElement(new ASN1Integer(integers.get(2)));
            againSequence.addSubElement(new ASN1Integer(integers.get(3)));
            internalSequence.addSubElement(againSequence);
            wrapper.addSubElement(internalSequence);
            ASN1Integer bigInt = new ASN1Integer(integers.get(5));
            DEROutputStream out = new DEROutputStream();
            bigInt.encodeToDER(out);
            wrapper.addSubElement(new ASN1OctetString(out.toByteArray()));
            out = new DEROutputStream();
            wrapper.encodeToDER(out);
            bytes = out.toByteArray();
        }
        catch (IOException ioe) {
            throw new PEMReaderException("Cannot convert PEM DSA Private Key to PKCS#8 encoded key.", ioe);
        }
        PEMObject result = new PEMObject();
        result.setType(PEMObject.Type.PrivateKey);
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("DSA");
            result.setPrivateKey(kf.generatePrivate(spec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new PEMReaderException("failed to generate DSA private key.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PEMReaderException("failed to generate DSA private key.", e);
        }
        return result;
    }
}

