/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.properties;

import com.sap.cloud.crypto.keystore.service.CacheAccessor;
import com.sap.cloud.crypto.keystore.service.types.TypesMapper;
import com.sap.core.tenant.api.Tenant;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesManager {
    private static final String CACHE_VALIDITY_PERIOD_PROPERTY = "configuration_cache_validity_period";
    private static final String CACHE_LAST_ACCESS_TIMEOUT_PROPERTY = "configuration_cache_last_access_timeout";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesManager.class);
    private static final PropertiesManager instance = new PropertiesManager();
    private final Map<String, String> defaultProperties = new HashMap<String, String>();
    private int cacheValidityPeriodInSeconds = 120;
    private int cacheLastAccessTimeoutInSeconds = 1800;

    private PropertiesManager() {
    }

    public static final PropertiesManager getInstance() {
        return instance;
    }

    public synchronized void updateProperties(Dictionary properties) {
        if (properties != null) {
            this.defaultProperties.clear();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = properties.get(key);
                if (!(key instanceof String) || !(value instanceof String)) continue;
                this.defaultProperties.put((String)key, (String)value);
            }
            LOG.debug("Update PropertiesManager manager properties with values: {}", this.defaultProperties);
            TypesMapper.updateServiceProperties(this.defaultProperties);
            String cacheValidityPeriod = this.defaultProperties.get(CACHE_VALIDITY_PERIOD_PROPERTY);
            String cacheLastAccessTimeout = this.defaultProperties.get(CACHE_LAST_ACCESS_TIMEOUT_PROPERTY);
            int oldCacheValidityPeriodInSeconds = this.cacheValidityPeriodInSeconds;
            int oldCacheLastAccessTimeoutInSeconds = this.cacheValidityPeriodInSeconds;
            if (cacheValidityPeriod != null && cacheValidityPeriod.trim().length() > 0) {
                try {
                    this.cacheValidityPeriodInSeconds = Integer.parseInt(cacheValidityPeriod.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warn("Configured cache validity period is not a number: {}", (Object)cacheValidityPeriod);
                }
            }
            if (cacheLastAccessTimeout != null && cacheLastAccessTimeout.trim().length() > 0) {
                try {
                    this.cacheLastAccessTimeoutInSeconds = Integer.parseInt(cacheLastAccessTimeout.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warn("Configured cache last access timeout is not a number: {}", (Object)cacheLastAccessTimeout);
                }
            }
            if (this.cacheValidityPeriodInSeconds != oldCacheValidityPeriodInSeconds || this.cacheLastAccessTimeoutInSeconds != oldCacheLastAccessTimeoutInSeconds) {
                CacheAccessor.getInstance().setTimeouts((long)this.cacheValidityPeriodInSeconds * 1000L, (long)this.cacheLastAccessTimeoutInSeconds * 1000L);
            }
        }
    }

    public String getTenantId() {
        String tenantId = Tenant.getId();
        if (this.defaultProperties.containsKey("tenant_mapping_source")) {
            String tenantMappingSource = this.defaultProperties.get("tenant_mapping_source");
            String tenantMappingTarget = this.defaultProperties.get("tenant_mapping_target");
            LOG.debug("tenantId: {}, tenantMappingSource: {}, tenantMappingTarget: {}", new Object[]{tenantId, tenantMappingSource, tenantMappingTarget});
            if (tenantMappingSource != null && tenantMappingTarget != null && tenantMappingSource.equalsIgnoreCase(tenantId)) {
                tenantId = tenantMappingTarget;
            }
        } else {
            LOG.debug("No tenant_mapping_source property is specified. Returning tenant: {}", (Object)tenantId);
        }
        return tenantId;
    }

    public int getCacheValidityPeriodInSeconds() {
        return this.cacheValidityPeriodInSeconds;
    }

    public int getCacheLastAccessTimeoutInSeconds() {
        return this.cacheLastAccessTimeoutInSeconds;
    }
}

