/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.keystore.service.types;

import com.sap.cloud.crypto.keystore.api.KeyStoreServiceException;
import com.sap.cloud.crypto.keystore.service.KeyStoreProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TypesMapper.class);
    private static HashMap<String, String> staticMappings = new HashMap();
    private static final HashMap<String, String> dynamicMappings = new HashMap();
    private static final String KEY_PREFIX = "keystore_type_";

    public static synchronized void updateServiceProperties(Map<String, String> defaultProperties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Default mappings before the update: " + staticMappings);
        }
        TypesMapper.resetStaticMappings();
        for (String key : defaultProperties.keySet()) {
            String fileExtension = TypesMapper.getStorageType(key);
            if (fileExtension.isEmpty()) continue;
            String keystoreType = defaultProperties.get(key);
            if (keystoreType != null && !(keystoreType = keystoreType.trim()).isEmpty()) {
                staticMappings.put(fileExtension.toLowerCase(Locale.ENGLISH), keystoreType.toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Empty value for keystore mapping property '" + key + "': " + keystoreType);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Default mappings after the update: " + staticMappings);
        }
    }

    private static void resetStaticMappings() {
        staticMappings.clear();
        Set<String> nativeTypes = KeyStoreProvider.getSupportedKeyStoreTypes();
        for (String type : nativeTypes) {
            type = type.toLowerCase(Locale.ENGLISH);
            staticMappings.put(type, type);
        }
    }

    public static synchronized String getKeyStoreType(String fileExtension) throws KeyStoreServiceException {
        String keystoreType = dynamicMappings.get(fileExtension = fileExtension.toLowerCase(Locale.ENGLISH));
        if (keystoreType == null) {
            keystoreType = staticMappings.get(fileExtension);
        }
        if (keystoreType == null) {
            keystoreType = fileExtension;
        }
        return keystoreType;
    }

    public static synchronized String getKeyStoreFileExtension(String type) {
        if (type == null) {
            return null;
        }
        String typeLower = type.toLowerCase(Locale.ENGLISH);
        String result = TypesMapper.getKeyByValue(dynamicMappings, typeLower);
        if (result != null) {
            return result;
        }
        result = TypesMapper.getKeyByValue(staticMappings, typeLower);
        if (result != null) {
            return result;
        }
        return typeLower;
    }

    private static String getKeyByValue(Map<String, String> map, String value) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            if (!map.get(key).equals(value)) continue;
            return key;
        }
        return null;
    }

    public static synchronized void registerMapping(String fileExtension, String keystoreType) throws KeyStoreServiceException {
        if ((fileExtension = fileExtension.toLowerCase(Locale.ENGLISH)).equals(keystoreType = keystoreType.toLowerCase(Locale.ENGLISH))) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Registration skipped - the given file extension equals to the given keystore type '" + keystoreType + "'.");
            }
            return;
        }
        String mappedKeystoreType = dynamicMappings.get(fileExtension);
        if (mappedKeystoreType != null && !mappedKeystoreType.equals(keystoreType)) {
            throw new KeyStoreServiceException("File extension '" + fileExtension + "' is already mapped to keystore type '" + mappedKeystoreType + "'.");
        }
        dynamicMappings.put(fileExtension, keystoreType);
        if (LOG.isInfoEnabled()) {
            LOG.info("Type mapping has been registered: " + fileExtension + " -> " + keystoreType);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\r\nInvocation stack:\r\n " + TypesMapper.getCallStack());
        }
    }

    private static String getCallStack() {
        StackTraceElement[] callStack = new Exception().getStackTrace();
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("-----------------------------------").append("\r\n");
            int i = 1;
            while (i < 5) {
                builder.append("  at ").append(callStack[i].getClassName()).append(".").append(callStack[i].getMethodName()).append(": ").append(callStack[i].getLineNumber()).append("\r\n");
                ++i;
            }
            builder.append("...").append("\r\n");
            builder.append("-----------------------------------").append("\r\n");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return builder.toString();
    }

    public static synchronized boolean unregisterMapping(String fileExtension, String keyStoreType) {
        fileExtension = fileExtension.toLowerCase(Locale.ENGLISH);
        keyStoreType = keyStoreType.toLowerCase(Locale.ENGLISH);
        String currentMapping = dynamicMappings.get(fileExtension);
        if (currentMapping == null || !currentMapping.equals(keyStoreType)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("mapping {" + fileExtension + " -> " + keyStoreType + " } has not been unregistered - found different mapped keystore type: " + currentMapping);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("\r\nInvocation stack:\r\n " + TypesMapper.getCallStack());
            }
            return false;
        }
        dynamicMappings.remove(fileExtension);
        if (LOG.isInfoEnabled()) {
            LOG.info("mapping {" + fileExtension + " -> " + keyStoreType + " } has been unregistered.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\r\nInvocation stack:\r\n " + TypesMapper.getCallStack());
        }
        return true;
    }

    public static synchronized void clear() {
        dynamicMappings.clear();
        staticMappings.clear();
    }

    private static String getStorageType(String property_key) {
        if (property_key != null && (property_key = property_key.toLowerCase(Locale.ENGLISH)).startsWith(KEY_PREFIX)) {
            return property_key.substring(KEY_PREFIX.length()).trim();
        }
        return "";
    }
}

