/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.commons.shared.json;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.cloud.runtime.tomcat.commons.shared.json.JsonParser;

public abstract class JsonParserFactory {
    private static final String FACTORY_CLASS_NAME = "com.sap.cloud.runtime.tomcat.commons.impl.json.DefaultJsonParserFactory";
    private static volatile Class<?> factoryImplementationClassCache;

    public static JsonParserFactory newJsonParserFactory() {
        try {
            Class<?> factoryImplementation = JsonParserFactory.loadFactoryImplementation();
            Object instance = factoryImplementation.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (JsonParserFactory)instance;
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException("Failed to load the server provided JsonParserFactory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> loadFactoryImplementation() throws ClassNotFoundException {
        if (null != factoryImplementationClassCache) return factoryImplementationClassCache;
        Class<JsonParserFactory> clazz = JsonParserFactory.class;
        synchronized (JsonParserFactory.class) {
            if (null != factoryImplementationClassCache) return factoryImplementationClassCache;
            ClassLoader implClassLoader = ClassloadingBridge.getImplClassLoader();
            Class<?> implementationClass = implClassLoader.loadClass(FACTORY_CLASS_NAME);
            factoryImplementationClassCache = implementationClass;
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryImplementationClassCache;
        }
    }

    public abstract JsonParser createJsonParser();
}

