/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.rest.client;

import com.google.gson.Gson;
import com.sap.core.log.dev.app.logs.AppLogConfiguration;
import com.sap.core.log.dev.app.logs.AppLogFile;
import com.sap.core.log.dev.app.logs.AppLogger;
import com.sap.core.log.dev.app.logs.AppLogs;
import com.sap.core.log.dev.rest.client.BasicAuthClient;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.ResetResult;
import com.sap.core.log.dev.rest.client.exceptions.ForbiddenException;
import com.sap.core.log.dev.rest.client.exceptions.LogOperationsException;
import com.sap.core.log.dev.rest.client.exceptions.NotFoundException;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.core.log.dev.rest.client.exceptions.UnsupportedLogLevelException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

public class AppLogsREST
implements IAppLogsREST {
    private static final Logger LOGGER = Logger.getLogger((String)AppLogsREST.class.getName());
    private static final String VERSION = "v1";
    private static final String LOGS_REQUEST = "/log/api_basic/v1/logs";
    private static final String LOGGERS_REQUEST = "/log/api_basic/v1/loggers";
    private static final String CSRF_TOKEN_HEADER_NAME = "X-CSRF-TOKEN";
    private static final String CSRF_TOKEN_HEADER_FETCH_VALUE = "Fetch";
    private static final String CSRF_TOKEN_RQUIRED = "X-CSRF-TOKEN: Required";
    private static final String PROP_KEY_ERROR_MESSAGE = "errorMessage";
    private static final String RESET_APP_LOGER_NAME = "*";
    private static final String RESET_APP_LOGER_LEVEL = "DEFAULT";
    AppLogger resetAppLogger = new AppLogger("*", "DEFAULT");
    private final BasicAuthClient basicAuthClient;
    private final HttpClient httpClient;
    private final String logsRequestPath;
    private final String loggersRequestPath;
    private Map<String, String> csrfTokens = new HashMap<String, String>();
    private AppLogger resetLoggersResult = null;

    public AppLogsREST(BasicAuthClient basicAuthClient) {
        this.basicAuthClient = AppLogsREST.notNull("basicAuthClient", basicAuthClient);
        this.httpClient = basicAuthClient.getHttpClient();
        String logsRequestPath = "/log/api_basic/v1/logs/" + basicAuthClient.getSpace() + "/" + basicAuthClient.getAppliance();
        if (basicAuthClient.getComponent() != null) {
            logsRequestPath = String.valueOf(logsRequestPath) + "/" + basicAuthClient.getComponent();
        }
        this.logsRequestPath = logsRequestPath;
        this.loggersRequestPath = basicAuthClient.getComponent() == null ? null : "/log/api_basic/v1/loggers/" + basicAuthClient.getSpace() + "/" + basicAuthClient.getAppliance() + "/" + basicAuthClient.getComponent();
    }

    @Override
    public List<AppLogFile> getAppLogFiles() throws LogOperationsException, NotFoundException, UnauthorizedException, ForbiddenException {
        AppLogs logs = this.convertHttpGetResponseToClassOfT(this.logsRequestPath, AppLogs.class, this.basicAuthClient.getLogServerURL());
        return logs.getLogFiles();
    }

    @Override
    public GZIPInputStream getAppLogFileStream(AppLogFile logFile) throws LogOperationsException, UnauthorizedException, ForbiddenException, NotFoundException {
        String logFileName = logFile.getName();
        if (this.basicAuthClient.getComponent() == null) {
            logFileName = String.valueOf(logFile.getComponent()) + "/" + logFileName;
        }
        return this.getAppLogFileStream(logFileName);
    }

    @Override
    public GZIPInputStream getAppLogFileStream(String logFileName) throws LogOperationsException, NotFoundException, UnauthorizedException, ForbiddenException {
        logFileName = this.doubleEncode(logFileName);
        HttpResponse response = this.makeHttpGetRequest(String.valueOf(this.logsRequestPath) + "/" + logFileName, this.basicAuthClient.getLogServerURL());
        try {
            return new GZIPInputStream(response.getEntity().getContent());
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new LogOperationsException(e.getMessage(), e);
        }
    }

    @Override
    public String getAppLogFileContent(String logFileName) throws LogOperationsException, UnauthorizedException, ForbiddenException, NotFoundException {
        GZIPInputStream gzipInput = this.getAppLogFileStream(logFileName);
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream(10240);
            int len = 0;
            byte[] bytes = new byte[65536];
            while ((len = gzipInput.read(bytes, 0, bytes.length)) >= 0) {
                byteArray.write(bytes, 0, len);
            }
            String string = byteArray.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new LogOperationsException(e.getMessage(), e);
        }
        finally {
            AppLogsREST.safeClose(gzipInput);
        }
    }

    @Override
    public List<AppLogger> getAppLoggers() throws LogOperationsException, UnauthorizedException, NotFoundException, ForbiddenException {
        this.ensureComponentIsNotNullForLoggers();
        AppLogConfiguration cfg = this.convertHttpGetResponseToClassOfT(this.loggersRequestPath, AppLogConfiguration.class, this.basicAuthClient.getLoggerServerURL());
        return cfg.getLoggers();
    }

    @Override
    public AppLogger getAppLogger(String logger) throws LogOperationsException, UnauthorizedException, NotFoundException, ForbiddenException {
        this.ensureComponentIsNotNullForLoggers();
        logger = this.doubleEncode(logger);
        AppLogger appLogger = this.convertHttpGetResponseToClassOfT(String.valueOf(this.loggersRequestPath) + "/" + logger, AppLogger.class, this.basicAuthClient.getLoggerServerURL());
        return appLogger;
    }

    @Override
    public void setAppLogger(AppLogger appLogger) throws LogOperationsException, UnauthorizedException, NotFoundException, UnsupportedLogLevelException {
        ArrayList<AppLogger> appLoggers = new ArrayList<AppLogger>(1);
        appLoggers.add(appLogger);
        this.setAppLoggers(appLoggers);
    }

    @Override
    public void setAppLoggers(List<AppLogger> appLoggers) throws LogOperationsException, UnauthorizedException, NotFoundException, UnsupportedLogLevelException {
        this.setAppLoggers(appLoggers, false);
    }

    public void setAppLoggers(List<AppLogger> appLoggers, boolean resetOperation) throws LogOperationsException, UnauthorizedException, NotFoundException, UnsupportedLogLevelException {
        HttpResponse response;
        block9: {
            this.ensureComponentIsNotNullForLoggers();
            response = null;
            try {
                try {
                    Gson gson = new Gson();
                    String json = gson.toJson(appLoggers);
                    StringEntity entity = new StringEntity(json);
                    entity.setContentType("application/json");
                    URL requestUrl = new URL(this.basicAuthClient.getLoggerServerURL(), this.loggersRequestPath);
                    String uri = requestUrl.toString();
                    HttpPut httpPut = new HttpPut(uri);
                    httpPut.setEntity((HttpEntity)entity);
                    HttpPut request = httpPut;
                    String csrfToken = this.getCsrfToken(this.basicAuthClient.getLoggerServerURL(), this.loggersRequestPath);
                    request.addHeader(CSRF_TOKEN_HEADER_NAME, csrfToken);
                    response = this.httpClient.execute((HttpUriRequest)request);
                    try {
                        this.checkResponseStatus((HttpUriRequest)request, response, this.loggersRequestPath, resetOperation);
                    }
                    catch (ForbiddenException e) {
                        StatusLine statusLine = response.getStatusLine();
                        if (CSRF_TOKEN_RQUIRED.equals(statusLine.getReasonPhrase())) {
                            this.csrfTokens.remove(this.loggersRequestPath);
                            String token = this.getCsrfToken(this.basicAuthClient.getLoggerServerURL(), this.loggersRequestPath);
                            request.addHeader(CSRF_TOKEN_HEADER_NAME, token);
                            response = this.httpClient.execute((HttpUriRequest)request);
                            this.checkResponseStatus((HttpUriRequest)request, response, this.loggersRequestPath, resetOperation);
                            break block9;
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new LogOperationsException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                if (response != null) {
                    this.readAndCloseResponse(response);
                }
                throw throwable;
            }
        }
        if (response != null) {
            this.readAndCloseResponse(response);
        }
    }

    private String getCsrfToken(URL serverUrl, String requestPath) throws IOException {
        String csrfToken = this.csrfTokens.get(requestPath);
        if (csrfToken != null) {
            return csrfToken;
        }
        HttpResponse response = null;
        try {
            String uri = new URL(serverUrl, requestPath).toString();
            HttpHead request = new HttpHead(uri);
            request.addHeader(CSRF_TOKEN_HEADER_NAME, CSRF_TOKEN_HEADER_FETCH_VALUE);
            response = this.httpClient.execute((HttpUriRequest)request);
            if (response.containsHeader(CSRF_TOKEN_HEADER_NAME)) {
                csrfToken = response.getFirstHeader(CSRF_TOKEN_HEADER_NAME).getValue();
                this.csrfTokens.put(requestPath, csrfToken);
            } else {
                LOGGER.warn((Object)"Could not obtain X-CSRF-TOKEN");
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                this.readAndCloseResponse(response);
            }
            throw throwable;
        }
        if (response != null) {
            this.readAndCloseResponse(response);
        }
        return csrfToken;
    }

    private void ensureComponentIsNotNullForLoggers() {
        if (this.loggersRequestPath == null) {
            throw new UnsupportedOperationException("The provided component name is null; cannot perform loggers operations on appliance level");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T convertHttpGetResponseToClassOfT(String requestPath, Class<T> jsonClass, URL serverURL) throws LogOperationsException {
        Object object;
        HttpResponse response = this.makeHttpGetRequest(requestPath, serverURL);
        InputStreamReader responseReader = null;
        try {
            responseReader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
            Gson gson = new Gson();
            object = gson.fromJson((Reader)responseReader, jsonClass);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new LogOperationsException(e.getMessage(), e);
                catch (RuntimeException e2) {
                    LOGGER.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new LogOperationsException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                AppLogsREST.safeClose(responseReader);
                throw throwable;
            }
        }
        AppLogsREST.safeClose(responseReader);
        return (T)object;
    }

    private HttpResponse makeHttpGetRequest(String requestPath, URL serverURL) throws LogOperationsException {
        try {
            URL request = new URL(serverURL, requestPath);
            HttpGet httpGet = new HttpGet(request.toString());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            this.checkResponseStatus((HttpUriRequest)httpGet, response, requestPath, false);
            return response;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new LogOperationsException(e.getMessage(), e);
        }
    }

    private void checkResponseStatus(HttpUriRequest request, HttpResponse response, String requestPath, boolean resetOperation) throws LogOperationsException, IOException {
        LogOperationsException exception;
        StatusLine statusLine = response.getStatusLine();
        int code = statusLine.getStatusCode();
        switch (code) {
            case 200: {
                if (resetOperation) {
                    InputStreamReader responseReader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
                    Gson gson = new Gson();
                    this.resetLoggersResult = (AppLogger)gson.fromJson((Reader)responseReader, AppLogger.class);
                }
                return;
            }
            case 404: {
                exception = new NotFoundException(this.getErrorMessage(response));
                break;
            }
            case 401: {
                exception = new UnauthorizedException(this.getErrorMessage(response));
                break;
            }
            case 403: {
                exception = new ForbiddenException(this.getErrorMessage(response));
                break;
            }
            case 400: {
                exception = new UnsupportedLogLevelException(this.getErrorMessage(response));
                break;
            }
            default: {
                exception = new LogOperationsException(String.valueOf(code) + " " + this.getErrorMessage(response));
            }
        }
        this.readAndCloseResponse(response);
        throw exception;
    }

    private String getErrorMessage(HttpResponse response) {
        String message;
        block5: {
            message = response.getStatusLine().getReasonPhrase();
            InputStreamReader responseReader = null;
            try {
                try {
                    responseReader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
                    Gson gson = new Gson();
                    Properties properties = (Properties)gson.fromJson((Reader)responseReader, Properties.class);
                    String errorMessage = properties.getProperty(PROP_KEY_ERROR_MESSAGE);
                    LOGGER.error((Object)("Get server error message " + errorMessage));
                    message = String.valueOf(message) + " " + errorMessage;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error when getting the error message", (Throwable)e);
                    AppLogsREST.safeClose(responseReader);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                AppLogsREST.safeClose(responseReader);
                throw throwable;
            }
            AppLogsREST.safeClose(responseReader);
        }
        return message;
    }

    private void readAndCloseResponse(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instream = null;
            try {
                try {
                    instream = entity.getContent();
                    byte[] buff = new byte[4096];
                    while (instream.read(buff) != -1) {
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (instream != null) {
                            instream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Cannot release HTTP connection", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    if (instream != null) {
                        instream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Cannot release HTTP connection", (Throwable)e);
                }
            }
        }
    }

    private String doubleEncode(String parameter) {
        try {
            parameter = URLEncoder.encode(parameter, "UTF-8");
            parameter = URLEncoder.encode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)("Could not encode parameter " + parameter), (Throwable)e);
        }
        return parameter;
    }

    static <T> T notNull(String varName, T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(varName) + " is null");
        }
        return value;
    }

    static String notNullAndNotEmpty(String varName, String value) {
        if (AppLogsREST.notNull(varName, value).isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(varName) + " is empty string");
        }
        return value;
    }

    static void safeClose(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception exception) {}
    }

    @Override
    public ResetResult resetAppLoggers() throws LogOperationsException, UnauthorizedException, ForbiddenException, NotFoundException, UnsupportedLogLevelException {
        this.resetLoggersResult = null;
        ArrayList<AppLogger> appLoggers = new ArrayList<AppLogger>(1);
        appLoggers.add(this.resetAppLogger);
        this.setAppLoggers(appLoggers, true);
        if ("OK".equals(this.resetLoggersResult.getLevel())) {
            return ResetResult.OK;
        }
        if ("Restart".equals(this.resetLoggersResult.getLevel())) {
            return ResetResult.Restart;
        }
        throw new LogOperationsException("Unknown server response");
    }
}

