/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.rest.client;

import com.sap.core.log.dev.rest.client.AppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public class BasicAuthClient {
    private static final String ORCHESTRATOR_SERVER_URL_PREFIX = "orchestrator.";
    private static final String LOGGING_SERVER_URL_PREFIX = "logapi.";
    private static final String LOGGER_SERVER_URL_PREFIX = "logconfig.";
    private final String space;
    private final String appliance;
    private final String component;
    private final DefaultHttpClient httpClient;
    private final URL landscapeURL;
    private final URL logURL;
    private final URL loggerURL;
    private final URL orchestratorURL;

    public BasicAuthClient(String landscapeURLString, String space, String appliance, HttpClient landscapeHttpClient) throws MalformedURLException, UnauthorizedException {
        this(landscapeURLString, space, appliance, null, landscapeHttpClient);
    }

    public BasicAuthClient(String landscapeURLString, String space, String appliance, String component, HttpClient landscapeHttpClient) throws MalformedURLException, UnauthorizedException {
        this(new URL(AppLogsREST.notNullAndNotEmpty("landscapeURLString", landscapeURLString)), space, appliance, component, landscapeHttpClient);
    }

    public BasicAuthClient(URL landscapeURL, String space, String appliance, HttpClient landscapeHttpClient) throws UnauthorizedException {
        this(landscapeURL, space, appliance, null, landscapeHttpClient);
    }

    public BasicAuthClient(URL landscapeURL, String space, String appliance, String component, HttpClient httpClient) throws UnauthorizedException {
        this.landscapeURL = AppLogsREST.notNull("landscapeURL", landscapeURL);
        try {
            this.logURL = BasicAuthClient.createLogServerURL(landscapeURL, LOGGING_SERVER_URL_PREFIX);
            this.loggerURL = BasicAuthClient.createLogServerURL(landscapeURL, LOGGER_SERVER_URL_PREFIX);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot determine Log Server URL", e);
        }
        try {
            this.orchestratorURL = BasicAuthClient.createOrchestratorURL(landscapeURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot determine Orchestrator URL", e);
        }
        this.space = AppLogsREST.notNullAndNotEmpty("space", space);
        this.appliance = AppLogsREST.notNullAndNotEmpty("appliance", appliance);
        if (component != null && component.isEmpty()) {
            throw new IllegalArgumentException("component is empty string");
        }
        this.component = component;
        this.httpClient = (DefaultHttpClient)AppLogsREST.notNull("httpClient", httpClient);
        this.init(this.logURL);
        this.init(this.loggerURL);
    }

    public String getSpace() {
        return this.space;
    }

    public String getAppliance() {
        return this.appliance;
    }

    public String getComponent() {
        return this.component;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public URL getLogServerURL() {
        return this.logURL;
    }

    public URL getLoggerServerURL() {
        return this.loggerURL;
    }

    private void init(URL url) throws UnauthorizedException {
        Credentials cr = this.getCredentials(url);
        if (cr != null) {
            return;
        }
        cr = this.getCredentials(this.landscapeURL);
        if (cr == null) {
            cr = this.getCredentials(this.orchestratorURL);
        }
        if (cr == null) {
            throw new UnauthorizedException("Credentials were not provided for " + this.landscapeURL);
        }
        this.httpClient.getCredentialsProvider().setCredentials(this.getScope(url), cr);
    }

    private Credentials getCredentials(URL url) {
        return this.httpClient.getCredentialsProvider().getCredentials(this.getScope(url));
    }

    private AuthScope getScope(URL url) {
        return new AuthScope(url.getHost(), url.getPort());
    }

    private static URL createLogServerURL(URL landscapeURL, String serverPrefix) throws MalformedURLException {
        return new URL(landscapeURL.getProtocol(), String.valueOf(serverPrefix) + landscapeURL.getHost(), landscapeURL.getPort(), "/");
    }

    private static URL createOrchestratorURL(URL landscapeURL) throws MalformedURLException {
        return new URL(landscapeURL.getProtocol(), ORCHESTRATOR_SERVER_URL_PREFIX + landscapeURL.getHost(), landscapeURL.getPort(), "/");
    }
}

