/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.valve;

import com.sap.core.tenant.common.TenantAdministrationException;
import com.sap.core.tenant.common.TenantData;
import com.sap.core.tenant.common.TenantDataAccessor;
import com.sap.core.tenant.common.TenantUtils;
import com.sap.core.tenant.valve.VisibleForTesting;
import com.sap.core.tenant.valve.helper.TenantValveHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;

public class TenantValidationValve
extends ValveBase {
    private static final Logger LOGGER = Logger.getLogger((String)TenantValidationValve.class.getName());
    private static final String HEADER_CERT = "SSL_CLIENT_CERT";
    private static final String REQUEST_HEADER_DOWNTIME = "hc_downtime";
    private static final String KEY_ACCOUNT_NAME_OF_TENANT = "account";
    protected TenantDataAccessor accessor;
    private TenantUtils tenantUtils = new TenantUtils();

    public TenantValidationValve() {
        super(true);
        this.initTenantDataAccessor();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        TenantData tenantData;
        String tenantId = this.readTenantIdFromRequest(request);
        if (LOGGER.isDebugEnabled()) {
            if (this.isValidTenantHostname(tenantId)) {
                LOGGER.debug((Object)String.format("Supplied Tenant Id [%s] is valid.", tenantId));
            } else {
                LOGGER.debug((Object)String.format("Supplied Tenant Id [%s] is not valid. Default tenant will be used.", tenantId));
            }
        }
        boolean isDowntime = Boolean.TRUE.toString().equals(request.getHeader(REQUEST_HEADER_DOWNTIME));
        try {
            if (isDowntime) {
                String serverName = request.getServerName();
                String urlPrefix = this.tenantUtils.getUrlPrefix(serverName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Detected downtime of app with URL prefix=" + urlPrefix));
                }
                tenantData = this.accessor.getTenantData(tenantId, urlPrefix);
            } else {
                tenantData = this.accessor.getTenantData(tenantId);
            }
            if (tenantId != null && tenantData == null) {
                LOGGER.warn((Object)("There is an attempt accessing this application with not valid tenant: " + tenantId));
                this.sendError(response, 503);
                return;
            }
        }
        catch (TenantAdministrationException e) {
            LOGGER.error((Object)"Error while retrieving tenant data", (Throwable)e);
            this.sendError(response, 503);
            return;
        }
        this.accessor.setCurrentTenantAndInherit(tenantData);
        try {
            this.invokeNextValve(request, response);
        }
        finally {
            if (tenantData == null) {
                LOGGER.debug((Object)"Null value is retrieved for tenant data.");
                request.setNote(KEY_ACCOUNT_NAME_OF_TENANT, null);
            } else {
                LOGGER.debug((Object)("Account name is added as a Catalina request note with name: account and value: " + tenantData.getAccountName()));
                request.setNote(KEY_ACCOUNT_NAME_OF_TENANT, (Object)tenantData.getAccountName());
            }
            this.accessor.removeCurrentTenant();
        }
    }

    @VisibleForTesting
    String readTenantIdFromRequest(Request request) {
        boolean readTenantFromUrlOrHeader;
        String tenantId = null;
        boolean bl = readTenantFromUrlOrHeader = !this.shouldIgnoreTenantFromUrl(request);
        if (readTenantFromUrlOrHeader) {
            String serverName = request.getServerName();
            tenantId = this.tenantUtils.getTenantId(serverName);
            if (tenantId == null) {
                tenantId = this.readTenantFromHeader(request);
            }
        } else {
            tenantId = this.readTenantFromHeader(request);
        }
        return tenantId;
    }

    private boolean shouldIgnoreTenantFromUrl(Request request) {
        String ignoreTenantFromUrl = request.getHeader(this.accessor.getIgnoreTenantFromURLHeaderName());
        if (ignoreTenantFromUrl == null) {
            return false;
        }
        return Boolean.valueOf(ignoreTenantFromUrl);
    }

    private String readTenantFromHeader(Request request) {
        String tenantAlias = request.getHeader(this.accessor.getTenantHeaderName());
        return tenantAlias;
    }

    protected void sendError(Response response, int errorCode) throws IOException {
        block2: {
            response.setError();
            try {
                response.reset();
                response.setContentType("text/html");
                response.setCharacterEncoding("utf-8");
                String errorMessage = sm.getString("http." + Integer.toString(errorCode));
                response.sendError(errorCode, errorMessage);
            }
            catch (IllegalStateException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug((Object)e);
            }
        }
        response.setSuspended(false);
    }

    private boolean isValidTenantHostname(String tenantHostname) {
        return tenantHostname != null && !tenantHostname.isEmpty();
    }

    private void invokeNextValve(Request request, Response response) throws IOException, ServletException {
        Valve nextValve = this.getNext();
        if (nextValve != null) {
            nextValve.invoke(request, response);
        }
    }

    public void startInternal() throws LifecycleException {
        super.startInternal();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"TenantValidationValve.start() method is called");
        }
    }

    public void stopInternal() throws LifecycleException {
        super.stopInternal();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"TenantValidationValve.stop() method is called");
        }
    }

    protected void initTenantDataAccessor() {
        this.accessor = new TenantValveHelper();
    }

    protected String getHttpErrorMesage(int errorCode) {
        return sm.getString("http." + Integer.toString(errorCode));
    }
}

