/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.ParameterException;
import com.sap.core.persistence.commands.AbstractComponentDataSourceCommand;
import com.sap.core.persistence.commands.BindingRequestExecutor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.Console;

public abstract class AbstractBindCommandWithDbUser
extends AbstractComponentDataSourceCommand {
    protected abstract BindingRequestExecutor.BindingType getBindingType();

    protected abstract String getId();

    protected abstract String getAccessToken();

    protected abstract String getDbUser();

    protected abstract String getDbPassword();

    @Override
    public void init() throws CommandException {
        CheckHelper.checkAccountAndAppSpecified((String)this.getAccount(), (String)this.getApplication());
        this.checkBothSchemaIdAndAccessToken();
        CheckHelper.checkArgSpecified(null, (String)"--db-user", (String)this.getDbUser());
        super.init();
    }

    public void run() throws CommandException {
        String accessToken;
        String dbPassword = this.retrieveDbPassword();
        String id = this.getId();
        if (id == null) {
            id = "";
        }
        if ((accessToken = this.getAccessToken()) == null) {
            accessToken = "";
        }
        BindingRequestExecutor bindingSchemaHelper = new BindingRequestExecutor(this.getAccount(), this.getApplication(), this.getComponent(), this.getDbUser(), dbPassword, this.getDataSourceName());
        bindingSchemaHelper.runBind(id, accessToken, this, this.getBindingType());
    }

    private String retrieveDbPassword() {
        String dbPassword = this.getDbPassword();
        if (dbPassword == null || dbPassword.trim().isEmpty()) {
            char[] passwd;
            this.getPassword();
            Console cons = System.console();
            if (cons != null && (passwd = cons.readPassword("%s", "Password for your database user: ")) != null && passwd.length > 0) {
                dbPassword = new String(passwd);
            }
            if (dbPassword == null || dbPassword.trim().isEmpty()) {
                throw new ParameterException("Both parameters '--db-user' and '--db-password' must be specified");
            }
        }
        return dbPassword;
    }

    private void checkBothSchemaIdAndAccessToken() {
        if (this.getId() != null && this.getAccessToken() != null) {
            throw new ParameterException("Parameters '--id' and '--access-token' are mutually exclusive and must not be specified together");
        }
        if (this.getId() == null && this.getAccessToken() == null) {
            throw new ParameterException("One of the parameters '--id' or '--access-token' must be specified");
        }
    }
}

