/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.ParameterException;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class AbstractDatabaseAccessPermissionsCommand
extends AbstractAccountCommand {
    private static final Pattern PERMISSIONS_SEPARATOR = Pattern.compile(",|'|\"");

    protected void checkDatabaseIdSpecified(String databaseId) {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)databaseId);
    }

    protected void checkToAccountSpecified(String toAccount) {
        CheckHelper.checkArgSpecified(null, (String)"--to-account", (String)toAccount);
    }

    protected void checkPermissionsSpecified(String permissions) {
        CheckHelper.checkArgSpecified(null, (String)"--permissions", (String)permissions);
    }

    protected List<Permission> parsePermissionsParameter(String permissionsParameter) {
        TreeSet<Permission> permissions = new TreeSet<Permission>(new Comparator<Permission>(){

            @Override
            public int compare(Permission o1, Permission o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        try {
            for (String permission : PERMISSIONS_SEPARATOR.split(permissionsParameter)) {
                if ((permission = permission.trim()).isEmpty()) continue;
                permissions.add(Permission.valueOf(permission.toUpperCase()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ParameterException("Invalid value in parameter '--permissions'. Acceptable values: 'TUNNEL', 'BINDING'.");
        }
        return Arrays.asList(permissions.toArray(new Permission[0]));
    }

    protected String getRequestPath(String databaseId) {
        return this.getRequestPath(databaseId, null, null);
    }

    protected String getRequestPath(String databaseId, String targetAccount, List<Permission> permissions) {
        StringBuilder requestPath = new StringBuilder("crossaccountdbpermissions");
        if (databaseId != null) {
            requestPath.append("/");
            requestPath.append(HttpClientProvider.encodeURLString((String)databaseId));
        }
        if (targetAccount != null && permissions != null && !permissions.isEmpty()) {
            requestPath.append("?");
            requestPath.append(this.getTargetAccountQueryParameter(targetAccount));
            requestPath.append("&");
            requestPath.append(this.getPermissionsQueryParameter(permissions));
        } else if (targetAccount != null) {
            requestPath.append("?");
            requestPath.append(this.getTargetAccountQueryParameter(targetAccount));
        } else if (permissions != null && !permissions.isEmpty()) {
            requestPath.append("?");
            requestPath.append(this.getPermissionsQueryParameter(permissions));
        }
        return requestPath.toString();
    }

    private String getTargetAccountQueryParameter(String targetAccount) {
        StringBuilder queryParameter = new StringBuilder("targetAccount=");
        queryParameter.append(targetAccount);
        return queryParameter.toString();
    }

    private String getPermissionsQueryParameter(List<Permission> permissions) {
        StringBuilder queryParameter = new StringBuilder("permissions=");
        int size = permissions.size();
        for (int i = 0; i < size; ++i) {
            queryParameter.append((Object)permissions.get(i));
            if (i >= size - 1) continue;
            queryParameter.append(",");
        }
        return queryParameter.toString();
    }

    protected static enum Permission {
        TUNNEL,
        BINDING;

    }
}

