/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractBindCommandWithDbUser;
import com.sap.core.persistence.commands.BindingRequestExecutor;

@Parameters(commandDescription="Binds a productive HANA instance to a Java application via a data source")
public class BindHanaDbmsCommand
extends AbstractBindCommandWithDbUser {
    private static final String CROSS_ACCOUNT_SEPARATOR = ":";
    static final String BIND_HANA_DBMS_COMMAND_NAME = "bind-hana-dbms";
    @Parameter(names={"-i", "--id"}, description="ID of the productive HANA instance that will be bound. If the database is owned by another subaccount, its ID must be supplied as 'accountName:databaseID'.")
    private String productiveHanaId = null;
    @Parameter(names={"--db-user"}, description="The name of the database user used to access the instance")
    private String dbUser = null;
    @Parameter(names={"--db-password"}, description="The password of the database user used to access the instance")
    private String dbPassword = null;
    @Parameter(names={"--access-token"}, description="Access token that identifies the grant")
    private String accessToken = null;

    public String getName() {
        return BIND_HANA_DBMS_COMMAND_NAME;
    }

    @Override
    protected BindingRequestExecutor.BindingType getBindingType() {
        return BindingRequestExecutor.BindingType.PRODUCTIVE_INSTANCE;
    }

    @Override
    protected String getId() {
        return this.productiveHanaId;
    }

    @Override
    protected String getDbUser() {
        return this.dbUser;
    }

    @Override
    protected String getDbPassword() {
        return this.dbPassword;
    }

    @Override
    protected String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void init() {
        if (this.productiveHanaId != null && this.productiveHanaId.contains(CROSS_ACCOUNT_SEPARATOR)) {
            throw new ParameterException("Bind-hana-dbms is not supported. Use bind-db to bind an application to a database in another subaccount of your global account.");
        }
        super.init();
    }
}

