/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractComponentDataSourceCommand;
import com.sap.core.persistence.commands.BindingRequestExecutor;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Binds a schema to a Java application via a data source")
public class BindSchemaCommand
extends AbstractComponentDataSourceCommand {
    static final String BIND_SCHEMA_COMMAND_NAME = "bind-schema";
    @Parameter(names={"-i", "--id"}, description="ID of the schema that will be bound.")
    private String schemaId = null;
    @Parameter(names={"--access-token"}, description="Access token that identifies the grant")
    private String accessToken = null;

    @Override
    public void init() throws CommandException {
        CheckHelper.checkAccountAndAppSpecified((String)this.getAccount(), (String)this.getApplication());
        this.checkBothSchemaIdAndAccessToken();
        if (this.schemaId == null) {
            this.schemaId = "";
        }
        if (this.accessToken == null) {
            this.accessToken = "";
        }
        super.init();
    }

    public String getName() {
        return BIND_SCHEMA_COMMAND_NAME;
    }

    public void run() throws CommandException {
        BindingRequestExecutor bindingSchemaHelper = new BindingRequestExecutor(this.getAccount(), this.getApplication(), this.getComponent(), null, null, this.getDataSourceName());
        bindingSchemaHelper.runBind(this.schemaId, this.accessToken, this, BindingRequestExecutor.BindingType.SCHEMA);
    }

    private void checkBothSchemaIdAndAccessToken() {
        if (this.schemaId != null && this.accessToken != null) {
            throw new ParameterException("Parameters '--id' and '--access-token' are mutually exclusive and must not be specified together");
        }
        if (this.schemaId == null && this.accessToken == null) {
            throw new ParameterException("One of the parameters '--id' or '--access-token' must be specified");
        }
    }
}

