/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.entities.BindingInfoEntity;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class BindingRequestExecutor {
    private String account;
    private String application;
    private String component;
    private String dataSourceName;
    private String dbUserName;
    private String dbUserPassword;

    public BindingRequestExecutor(String account, String application, String component, String dbUserName, String dbUserPassword, String dataSourceName) {
        this.account = account;
        this.application = application;
        this.component = component;
        this.dbUserName = dbUserName;
        this.dbUserPassword = dbUserPassword;
        this.dataSourceName = dataSourceName;
    }

    String getBindingUriPath() {
        String uriPath = "binding/" + this.application + "/" + this.component;
        if (this.isDataSourceNameSpecified()) {
            String encodedDataSourceName;
            try {
                encodedDataSourceName = BindingRequestExecutor.getEncodedDataSource(this.dataSourceName);
            }
            catch (UnsupportedEncodingException e) {
                throw new CommandException("An internal error occurred encoding the data source.", (Throwable)e, 166);
            }
            uriPath = uriPath + "/" + encodedDataSourceName;
        }
        return uriPath;
    }

    static String getEncodedDataSource(String dataSourceName) throws UnsupportedEncodingException {
        String[] parts = dataSourceName.split("/");
        String result = "";
        for (int i = 0; i < parts.length; ++i) {
            result = result + URLEncoder.encode(parts[i], "UTF-8");
            if (i >= parts.length - 1) continue;
            result = result + "/";
        }
        if (dataSourceName.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public String getAccountApplicationComponentMsg() {
        String result = "subaccount '" + this.account + "', application '" + this.application + "'";
        if (!"web".equals(this.component)) {
            result = result + ", component '" + this.component + "'";
        }
        return result;
    }

    String getDatabaseUserMessage() {
        String result = "";
        if (this.dbUserName != null) {
            result = " using database user '" + this.dbUserName + "'";
        }
        return result;
    }

    public String getToDataSourceMsg() {
        if (this.isDataSourceNameSpecified()) {
            return " to the data source '" + this.dataSourceName + "'";
        }
        return " to the default data source";
    }

    public String getFromDataSourceMsg() {
        if (this.isDataSourceNameSpecified()) {
            return " from the data source '" + this.dataSourceName + "'";
        }
        return " from the default data source";
    }

    private boolean isDataSourceNameSpecified() {
        return this.dataSourceName != null && this.dataSourceName.trim().length() > 0;
    }

    public void runBind(String schemaId, String accessToken, ICommandTunnelCommand command, BindingType bindingType) {
        JsonObject entity = new JsonObject();
        entity.addProperty("schemaId", schemaId);
        entity.addProperty("accessToken", accessToken);
        entity.addProperty("bindingType", bindingType.name());
        if (this.dbUserName != null) {
            entity.addProperty("dbUserName", this.dbUserName);
            entity.addProperty("dbUserPassword", this.dbUserPassword);
        }
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(entity);
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new BindingConsumer(schemaId, bindingType), command, this.getBindingUriPath());
        helper.executeRequest();
    }

    public void runUnBind(ICommandTunnelCommand command, BindingType bindingType) {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpDeleteStrategy(), (HttpResponseConsumingStrategy)new UnbindingConsumer(bindingType), command, this.getBindingUriPath());
        helper.executeRequest();
    }

    public static enum BindingType {
        SCHEMA,
        PRODUCTIVE_INSTANCE,
        DATABASE;

    }

    class UnbindingConsumer
    extends JsonConsumingStrategy<BindingInfoEntity> {
        private static final String EMPTY_STRING = "";
        private BindingType bindingType;

        public UnbindingConsumer(BindingType bindingType) {
            super(BindingInfoEntity.class);
            this.bindingType = bindingType;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 200) {
                if (this.bindingType == BindingType.PRODUCTIVE_INSTANCE) {
                    System.out.println("Productive HANA instance " + this.getId(context) + " unbound" + BindingRequestExecutor.this.getFromDataSourceMsg() + " of " + BindingRequestExecutor.this.getAccountApplicationComponentMsg());
                } else if (this.bindingType == BindingType.DATABASE) {
                    System.out.println("Database " + this.getId(context) + " unbound" + BindingRequestExecutor.this.getFromDataSourceMsg() + " of " + BindingRequestExecutor.this.getAccountApplicationComponentMsg());
                } else {
                    System.out.println("Schema" + this.getId(context) + " unbound" + BindingRequestExecutor.this.getFromDataSourceMsg() + " of " + BindingRequestExecutor.this.getAccountApplicationComponentMsg());
                }
            } else if (statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }

        private String getId(HttpResponseContext context) {
            String idFromEntity;
            BindingInfoEntity bindingInfoEntity;
            String id = EMPTY_STRING;
            if (this.isJsonMimeType(context) && (bindingInfoEntity = (BindingInfoEntity)this.getJsonObject(context)) != null && (idFromEntity = bindingInfoEntity.getSchemaID()) != null) {
                id = " '" + idFromEntity + "'";
            }
            return id;
        }
    }

    class BindingConsumer
    extends DefaultResponseConsumingStrategy {
        private String id;
        private BindingType bindingType;

        public BindingConsumer(String id, BindingType bindingType) {
            this.id = id;
            this.bindingType = bindingType;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 201) {
                if (this.id == null || this.id.length() == 0) {
                    this.id = context.getResponseContentString();
                }
                if (this.bindingType == BindingType.PRODUCTIVE_INSTANCE) {
                    System.out.println("Productive HANA instance '" + this.id + "' bound" + BindingRequestExecutor.this.getToDataSourceMsg() + " of the " + BindingRequestExecutor.this.getAccountApplicationComponentMsg() + BindingRequestExecutor.this.getDatabaseUserMessage());
                } else if (this.bindingType == BindingType.DATABASE) {
                    System.out.println("Database '" + this.id + "' bound" + BindingRequestExecutor.this.getToDataSourceMsg() + " of the " + BindingRequestExecutor.this.getAccountApplicationComponentMsg() + BindingRequestExecutor.this.getDatabaseUserMessage());
                } else {
                    String idName = "Schema";
                    String responseString = context.getResponseContentString();
                    if (responseString != null && responseString.length() > 0) {
                        idName = "Productive HANA instance";
                        System.out.println(responseString);
                    }
                    System.out.println(idName + " '" + this.id + "' bound" + BindingRequestExecutor.this.getToDataSourceMsg() + " of the " + BindingRequestExecutor.this.getAccountApplicationComponentMsg() + BindingRequestExecutor.this.getDatabaseUserMessage());
                }
            } else if (statusCode == 400 || statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else if (statusCode == 500 && !BindingRequestExecutor.this.isDataSourceNameSpecified()) {
                this.throwCommandExceptionWithContentInfoAndLog("Failed to bind the schema" + BindingRequestExecutor.this.getToDataSourceMsg() + " of the " + BindingRequestExecutor.this.getAccountApplicationComponentMsg() + ". Named data sources can't be bound to applications " + "that haven't been deployed yet. The default data source will be bound when the " + "application is started.", context);
            } else {
                super.consume(context);
            }
        }
    }
}

