/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.util.DBTypeConversion;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Creates a database schema with the specified ID on a shared or dedicated database system")
public class CreateSchema
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="Schema ID. Starts with a letter and contains 'a' - 'z', 'A' - 'Z', '0' - '9', '.' and '-'.")
    private String id;
    static final String CREATE_SCHEMA_COMMAND_NAME = "create-schema";
    Logger LOGGER = Logger.getLogger(CreateSchema.class);
    @Parameter(names={"-d", "--dbtype"}, description="Creates the schema on a shared database system.\n                      Syntax: 'type:version'. Version is optional.\n                      Acceptable type values: 'MaxDB', 'HANA', 'HANAXS' (case-insensitive).\n                      To see the acceptable version values, execute 'list-dbms'.", required=false)
    private String dbTypeParameter;
    @Parameter(names={"--dbsystem"}, description="Creates the schema on a dedicated database system.\n                      To see the available dedicated systems, execute 'list-dbms'.", required=false)
    private String dbSystemParameter;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgSchemaId();
        this.checkIfBothDbTypeAndDbSystemAreSpecified();
        super.init();
    }

    private void checkArgSchemaId() {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.id);
    }

    private void checkIfBothDbTypeAndDbSystemAreSpecified() {
        if (this.dbTypeParameter != null && this.dbSystemParameter != null) {
            throw new ParameterException("parameters '--dbtype' and '--dbsystem' are mutually exclusive and must not be specified together");
        }
    }

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return CREATE_SCHEMA_COMMAND_NAME;
    }

    public void run() throws CommandException {
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new CreateSchemaConsumer(), (ICommandTunnelCommand)this, "schema/" + HttpClientProvider.encodeURLString((String)this.id));
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        if (this.dbTypeParameter != null) {
            DbTypeParameterParser dbTypeParser = new DbTypeParameterParser(this.dbTypeParameter);
            props.addProperty("dbtype", dbTypeParser.getDbType());
            if (dbTypeParser.getDbVersion() != null) {
                props.addProperty("dbversion", dbTypeParser.getDbVersion());
            }
        }
        if (this.dbSystemParameter != null) {
            props.addProperty("dbsystem", this.dbSystemParameter);
        }
        return props;
    }

    private static class DbTypeParameterParser {
        private String dbType;
        private String dbVersion;

        DbTypeParameterParser(String dbTypeParameter) {
            if (dbTypeParameter != null) {
                int separatorIndex = dbTypeParameter.indexOf(58);
                if (separatorIndex >= 0) {
                    this.dbType = dbTypeParameter.substring(0, separatorIndex);
                    this.dbVersion = dbTypeParameter.substring(separatorIndex + 1);
                } else {
                    this.dbType = dbTypeParameter;
                }
                this.dbType = DBTypeConversion.getDBType(this.dbType);
            }
        }

        String getDbType() {
            return this.dbType;
        }

        String getDbVersion() {
            return this.dbVersion;
        }
    }

    class CreateSchemaConsumer
    extends DefaultResponseConsumingStrategy {
        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 201) {
                System.out.println("Schema created: " + context.getResponseContentString());
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

