/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.BindingInfoEntity;
import com.sap.core.persistence.commands.entities.Schema;
import com.sap.core.tunnelcommands.framework.executor.CommandExecutionContext;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.Console;

@Parameters(commandDescription="Deletes the schema with the specified ID and all related database artifacts (tables, indexes, DB user, etc.)")
public class DeleteSchema
extends AbstractAccountCommand {
    static final String DELETE_SCHEMA_COMMAND_NAME = "delete-schema";
    @Parameter(names={"-i", "--id"}, description="Schema ID.")
    private String id;
    @Parameter(names={"-f", "--force"}, description="(optional) Forcefully deletes the schema, including all application bindings")
    private boolean force = false;
    @Parameter(names={"--silent"}, description="(optional) Suppresses the command line confirmation prompt")
    private boolean silent = false;

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return DELETE_SCHEMA_COMMAND_NAME;
    }

    @Override
    public void init() throws CommandException {
        this.checkArgID();
        super.init();
    }

    public void checkArgID() {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.id);
    }

    public void run() throws CommandException {
        if (this.silent || this.userConfirm()) {
            CommandExecutionContext context = new CommandExecutionContext();
            if (this.executeCheckIfDeletionIsAllowed(context)) {
                this.executeDeleteSchema(context);
            }
        } else {
            throw new CommandException("User declined the deletion.", 50);
        }
    }

    private boolean userConfirm() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console available. Please use parameter --force to force the deletion.", 167);
        }
        System.out.println("Are you sure you want to permanently delete the schema '" + this.id + "'? This operation cannot be reverted. (yes/no) ");
        String answer = cons.readLine().toLowerCase();
        return "yes".equals(answer) || "y".equals(answer);
    }

    private boolean executeCheckIfDeletionIsAllowed(CommandExecutionContext context) {
        CheckIfDeletionIsAllowedConsumer consumer = new CheckIfDeletionIsAllowedConsumer();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)consumer, (ICommandTunnelCommand)this, "schema/" + HttpClientProvider.encodeURLString((String)this.id));
        helper.executeRequest();
        return consumer.isDeletionAllowed();
    }

    private void executeDeleteSchema(CommandExecutionContext context) {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)new HttpDeleteStrategy(), (HttpResponseConsumingStrategy)new DeleteSchemaConsumer(), (ICommandTunnelCommand)this, "schema/" + HttpClientProvider.encodeURLString((String)this.id));
        helper.executeRequest();
    }

    protected class CheckIfDeletionIsAllowedConsumer
    extends JsonConsumingStrategy<Schema> {
        private boolean isDeletionAllowed;

        public CheckIfDeletionIsAllowedConsumer() {
            super(Schema.class);
            this.isDeletionAllowed = false;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.consume((Schema)this.getJsonObject(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }

        void consume(Schema schema) {
            this.determineIfDeletionAllowed(schema);
        }

        void determineIfDeletionAllowed(Schema schema) {
            if (schema.getBindings() == null || schema.getBindings().length == 0) {
                this.isDeletionAllowed = true;
                return;
            }
            if (schema.getBindings().length > 0 && !DeleteSchema.this.force) {
                System.out.println("Schema '" + DeleteSchema.this.id + "' cannot be deleted because there are still bindings to it. Unbind all the bindings before deleting the schema or use the '" + "--force" + "' parameter.");
                this.printBindingInfo(schema);
                this.isDeletionAllowed = false;
            } else {
                System.out.println("Schema with ID '" + DeleteSchema.this.id + "' has existing bindings that will be forcefully deleted together with the schema.");
                this.printBindingInfo(schema);
                this.isDeletionAllowed = true;
            }
        }

        private void printBindingInfo(Schema schema) {
            System.out.println("Bindings");
            FormattedTable table = new FormattedTable(new String[]{"Application", "Data-source"});
            for (BindingInfoEntity bindingInfo : schema.getBindings()) {
                if (bindingInfo == null) continue;
                table.addRow(new String[]{bindingInfo.getApplication(), bindingInfo.getDataSourceName()});
            }
            table.printTo(System.out, "  ");
        }

        boolean isDeletionAllowed() {
            return this.isDeletionAllowed;
        }
    }

    class DeleteSchemaConsumer
    extends DefaultResponseConsumingStrategy {
        DeleteSchemaConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            if (statusCode == 200) {
                System.out.println("Schema '" + DeleteSchema.this.id + "' was deleted.");
            } else if (statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog("Could not delete schema '" + DeleteSchema.this.id + "'.", context);
            } else {
                super.consume(context);
            }
        }
    }
}

