/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.BindingInfoEntity;
import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.persistence.commands.entities.EventLogEntryEntity;
import com.sap.core.persistence.commands.tunnel.connection.DBSpecificHelper;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

@Parameters(commandDescription="Retrieves detailed information about the database")
public class DisplayDbInfoCommand
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="Database ID")
    private String id;
    @Parameter(names={"--show-components"}, description="(optional, default: false) Shows component names in the list of bindings", hidden=true, required=false)
    private boolean showComponents = false;
    @Parameter(names={"--show-log"}, description="(optional, default: false) Shows event logs", hidden=true, required=false)
    private boolean showLog = false;
    static final String DB_STATE_LABEL = "DB State:       ";
    static final String DB_TYPE_LABEL = "DB Type:        ";
    static final String DB_SYSTEM_LABEL = "DB System:      ";
    static final String DB_VERSION_LABEL = "DB Version:     ";
    static final String DB_SIZE_DATA_TOTAL_LABEL = "DB Size Total:  ";
    static final String DB_SIZE_DATA_USED_LABEL = "DB Size Used:   ";
    static final String PARAMETERS_LABEL = "Parameters";
    static final String BINDINGS_LABEL = "Bindings";
    static final String EVENT_LOG_LABEL = "Event Log";
    static final String DISPLAY_DB_INFO_COMMAND_NAME = "display-db-info";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final DateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS'Z'");

    private static String renderUtcDate(Date date) {
        ISO_8601_DATE_FORMAT.setTimeZone(UTC_TIMEZONE);
        return ISO_8601_DATE_FORMAT.format(date);
    }

    @Override
    public void init() throws CommandException {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.id);
        super.init();
    }

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return DISPLAY_DB_INFO_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new DisplayDbsInfoConsumer(), (ICommandTunnelCommand)this, "common/databases/" + HttpClientProvider.encodeURLString((String)this.id) + (this.showLog ? "?eventLog=true" : ""));
        helper.executeRequest();
    }

    protected class DisplayDbsInfoConsumer
    extends JsonConsumingStrategy<DbsInfoEntity> {
        protected DisplayDbsInfoConsumer() {
            super(DbsInfoEntity.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.printResult((DbsInfoEntity)this.getJsonObject(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }

        private void printResult(DbsInfoEntity info) {
            System.out.println("Database '" + info.getDatabaseId() + "' properties:");
            System.out.println("  DB State:       " + info.getDbState());
            System.out.println("  DB Type:        " + info.getDbType());
            System.out.println("  DB System:      " + info.getDbSystemName());
            System.out.println("  DB Version:     " + info.getDbVersion());
            DBSpecificHelper.DbType type = DBSpecificHelper.DbType.valueOf(info.getDbType());
            if (DBSpecificHelper.DbType.ase.equals((Object)type)) {
                this.printASESpecifics(info);
            } else if (DBSpecificHelper.DbType.hanamdc.equals((Object)type)) {
                this.printHANAMDCSpecifics(info);
            }
            this.printBindingsTable(info);
            if (DisplayDbInfoCommand.this.showLog) {
                this.printEventLog(info);
            }
        }

        private void printHANAMDCSpecifics(DbsInfoEntity info) {
            System.out.println("  Parameters");
            if (info.getParameters() != null) {
                System.out.println("    Web Access:     " + (Object)((Object)info.getParameters().getWebAccessMode()));
                System.out.println("    XS Engine Mode: " + (Object)((Object)info.getParameters().getXsEngineMode()));
            } else {
                System.out.println("    ---");
            }
        }

        private void printASESpecifics(DbsInfoEntity info) {
            if (info.getParameters() != null) {
                System.out.println("  DB Size Total:  " + this.readableBytes(info.getParameters().getDbSizeDataTotal()));
            }
            if (info.getDetails() != null) {
                System.out.println("  DB Size Used:   " + this.readableBytes(info.getDetails().getDbSizeDataUsed()));
            }
        }

        private String readableBytes(Long size) {
            if (size <= 0L) {
                return "0";
            }
            String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
            int digitGroups = (int)(Math.log10(size.longValue()) / Math.log10(1024.0));
            return new DecimalFormat("#,##0.#").format((double)size.longValue() / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
        }

        private void printBindingsTable(DbsInfoEntity info) {
            System.out.println("  Bindings");
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Application");
            if (DisplayDbInfoCommand.this.showComponents) {
                headers.add("Component");
            }
            headers.add("Data Source");
            headers.add("DB User");
            FormattedTable table = new FormattedTable(headers.toArray(new String[headers.size()]));
            if (info.getBindings() != null) {
                for (BindingInfoEntity bindingInfo : info.getBindings()) {
                    if (bindingInfo == null) continue;
                    ArrayList<String> entries = new ArrayList<String>();
                    entries.add(bindingInfo.getApplication());
                    if (DisplayDbInfoCommand.this.showComponents) {
                        entries.add(bindingInfo.getComponent());
                    }
                    entries.add(bindingInfo.getDataSourceName());
                    entries.add(bindingInfo.getDbUserName());
                    table.addRow(entries.toArray(new String[entries.size()]));
                }
            }
            table.printTo(System.out, "    ");
        }

        private void printEventLog(DbsInfoEntity info) {
            System.out.println("  Event Log");
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Timestamp");
            headers.add("Request ID");
            headers.add("Status");
            headers.add("Operation");
            headers.add("Description");
            headers.add("Error Text");
            headers.add("Error ID");
            headers.add("Started By");
            FormattedTable logTable = new FormattedTable(headers.toArray(new String[headers.size()]));
            EventLogEntryEntity[] eventLogEntries = info.getEventLogEntries();
            if (eventLogEntries != null) {
                for (EventLogEntryEntity logEntryInfo : eventLogEntries) {
                    if (logEntryInfo == null) continue;
                    ArrayList<String> entries = new ArrayList<String>();
                    entries.add(DisplayDbInfoCommand.renderUtcDate(new Date(logEntryInfo.getEventTimestamp())));
                    entries.add(logEntryInfo.getRequestId());
                    entries.add(logEntryInfo.getStatus());
                    entries.add(logEntryInfo.getOperation());
                    entries.add(logEntryInfo.getDescription());
                    entries.add(logEntryInfo.getErrorText());
                    entries.add(logEntryInfo.getErrorId());
                    entries.add(logEntryInfo.getStartedBy());
                    logTable.addRow(entries.toArray(new String[entries.size()]));
                }
            }
            logTable.printTo(System.out, "    ");
        }
    }
}

