/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.BindingInfoEntity;
import com.sap.core.persistence.commands.entities.Schema;
import com.sap.core.persistence.commands.util.DBTypeConversion;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.util.ArrayList;

@Parameters(commandDescription="Retrieves detailed information about the schema")
public class DisplaySchemaInfoCommand
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="Database or schema ID. Starts with a letter and contains 'a' - 'z' and '0' - '9'. For schema IDs, 'A' - 'Z', '.' and '-' are also allowed.")
    private String id;
    @Parameter(names={"--show-components"}, description="(optional, default: false) Shows component names in the list of bindings", hidden=true, required=false)
    private boolean showComponents = false;
    static final String DB_TYPE_LABEL = "DB Type: ";
    static final String DB_SYSTEM_LABEL = "DB System: ";
    static final String BINDINGS_LABEL = "Bindings";
    static final String DB_VERSION_LABEL = "DB Version: ";
    static final String DISPLAY_SCHEMA_INFO_COMMAND_NAME = "display-schema-info";

    @Override
    public void init() throws CommandException {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.id);
        super.init();
    }

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return DISPLAY_SCHEMA_INFO_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new DisplaySchemaInfoConsumer(), (ICommandTunnelCommand)this, "schema/" + HttpClientProvider.encodeURLString((String)this.id));
        helper.executeRequest();
    }

    DisplaySchemaInfoCommand getNewListSchemaConsumer() {
        return new DisplaySchemaInfoCommand();
    }

    protected class DisplaySchemaInfoConsumer
    extends JsonConsumingStrategy<Schema> {
        protected DisplaySchemaInfoConsumer() {
            super(Schema.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.consume((Schema)this.getJsonObject(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }

        void consume(Schema schema) {
            this.printResult(schema);
        }

        private void printResult(Schema schema) {
            System.out.println("Schema '" + schema.getSchemaId() + "' properties:");
            System.out.println("  DB Type: " + DBTypeConversion.getDisplayName(schema.getDbType()));
            System.out.println("  DB System: " + schema.getDisplayDBSystemName());
            System.out.println("  DB Version: " + schema.getDisplayDBVersion());
            System.out.println("  Bindings");
            boolean showUser = this.showUser(schema);
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Application");
            if (DisplaySchemaInfoCommand.this.showComponents) {
                headers.add("Component");
            }
            headers.add("Data-source");
            if (showUser) {
                headers.add("Database User");
            }
            FormattedTable table = new FormattedTable(headers.toArray(new String[headers.size()]));
            if (schema.getBindings() != null) {
                for (BindingInfoEntity bindingInfo : schema.getBindings()) {
                    if (bindingInfo == null) continue;
                    ArrayList<String> entries = new ArrayList<String>();
                    entries.add(bindingInfo.getApplication());
                    if (DisplaySchemaInfoCommand.this.showComponents) {
                        entries.add(bindingInfo.getComponent());
                    }
                    entries.add(bindingInfo.getDataSourceName());
                    if (showUser) {
                        entries.add(bindingInfo.getDbUserName());
                    }
                    table.addRow(entries.toArray(new String[entries.size()]));
                }
            }
            table.printTo(System.out, "    ");
        }

        private boolean showUser(Schema schema) {
            boolean showUser = false;
            if (schema.getBindings() != null) {
                for (BindingInfoEntity bindingInfo : schema.getBindings()) {
                    if (bindingInfo.getDbUserName() == null) continue;
                    showUser = true;
                    break;
                }
            }
            return showUser;
        }
    }
}

