/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractDatabaseAccessPermissionsCommand;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.List;

@Parameters(commandDescription="Provides another subaccount with permissions to access a database. The subaccount providing the permissions and the subaccount receiving the permissions must both be part of the same global account.")
public class GrantDatabaseAccessCommand
extends AbstractDatabaseAccessPermissionsCommand {
    private static final String GRANT_DATABASE_ACCESS_COMMAND_NAME = "grant-db-access";
    @Parameter(names={"-i", "--id"}, description="ID of the database to which access will be granted.")
    private String id;
    @Parameter(names={"--to-account"}, description="The subaccount to receive access permissions. Must be in the same global account as the providing subaccount.")
    private String toAccount;
    @Parameter(names={"--permissions"}, description="Comma-separated list of access permissions to the database. Acceptable values: 'TUNNEL', 'BINDING'.")
    private String permissionsParameter;
    private List<AbstractDatabaseAccessPermissionsCommand.Permission> permissions = new ArrayList<AbstractDatabaseAccessPermissionsCommand.Permission>();

    public String getId() {
        return this.id;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public List<AbstractDatabaseAccessPermissionsCommand.Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    public void init() throws CommandException {
        super.init();
        this.checkDatabaseIdSpecified(this.id);
        this.checkToAccountSpecified(this.toAccount);
        this.checkPermissionsSpecified(this.permissionsParameter);
        this.permissions.addAll(this.parsePermissionsParameter(this.permissionsParameter));
    }

    public void run() throws CommandException {
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.createRequestEntity(this.getToAccount(), this.getPermissions()));
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new GrantDatabaseAccessConsumer(), (ICommandTunnelCommand)this, this.getRequestPath(this.getId()));
        helper.executeRequest();
    }

    private JsonObject createRequestEntity(String targetAccount, List<AbstractDatabaseAccessPermissionsCommand.Permission> permissions) {
        return (JsonObject)new Gson().toJsonTree((Object)new GrantDatabaseAccessEntity(targetAccount, permissions));
    }

    public String getName() {
        return GRANT_DATABASE_ACCESS_COMMAND_NAME;
    }

    public String getGroup() {
        return "persistence";
    }

    private static class GrantDatabaseAccessEntity {
        private String targetAccount;
        private List<AbstractDatabaseAccessPermissionsCommand.Permission> permissions;

        public GrantDatabaseAccessEntity(String targetAccount, List<AbstractDatabaseAccessPermissionsCommand.Permission> permissions) {
            this.targetAccount = targetAccount;
            this.permissions = permissions;
        }
    }

    private static class GrantDatabaseAccessConsumer
    extends DefaultResponseConsumingStrategy {
        private static final String SUCCESS_MESSAGE = "Request to grant permissions sent. The change may take a few minutes. Use list-db-access-permissions to check the outcome.";
        private static final String NOT_MODIFIED_MESSAGE = "No new permissions to be granted.";

        private GrantDatabaseAccessConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 202) {
                System.out.println(SUCCESS_MESSAGE);
            } else if (statusCode == 304) {
                System.out.println(NOT_MODIFIED_MESSAGE);
            } else if (statusCode == 400 || statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

