/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Grants an application in another subaccount access to a schema based on a one-time access token. The access token is used to bind the schema to the application")
public class GrantSchemaAccessCommand
extends AbstractAccountCommand {
    @Parameter(names={"-i", "--id"}, description="Database or schema ID.")
    private String id;
    @Parameter(names={"-b", "--application"}, description="The application (specified in the format <account>:<application>) to which the schema can be bound using the created token.")
    private String grantedToParameter;
    static final String GRANT_SCHEMA_ACCESS_COMMAND_NAME = "grant-schema-access";
    Logger LOGGER = Logger.getLogger(GrantSchemaAccessCommand.class);
    private String toAccount = null;
    private String toApplication = null;

    @Override
    public void init() throws CommandException {
        super.init();
        this.checkArgSchemaId();
        String[] parameters = GrantSchemaAccessCommand.separateAndCheckGrantedToParameter(this.grantedToParameter);
        this.toAccount = parameters[0];
        this.toApplication = parameters[1];
        if (this.getAccount().equals(this.toAccount)) {
            String msg = "Subaccounts of schema and application must be different";
            throw new ParameterException(msg);
        }
    }

    private void checkArgSchemaId() {
        CheckHelper.checkArgSpecified((String)"-i", (String)"--id", (String)this.id);
    }

    static String[] separateAndCheckGrantedToParameter(String grantedToParameter) {
        int separatorIndex;
        if (grantedToParameter != null && (separatorIndex = grantedToParameter.indexOf(58)) >= 0) {
            String toAccount = grantedToParameter.substring(0, separatorIndex);
            String toApplication = grantedToParameter.substring(separatorIndex + 1);
            if (toAccount.length() > 0 && toApplication.length() > 0) {
                return new String[]{toAccount, toApplication};
            }
        }
        throw new ParameterException("Parameter '-b' or '--application' must be specified in the format <account>:<application>");
    }

    public String getName() {
        return GRANT_SCHEMA_ACCESS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new CreateAccessTokenConsumer(), (ICommandTunnelCommand)this, "accesstoken/");
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        props.addProperty("toaccount", this.toAccount);
        props.addProperty("toapplication", this.toApplication);
        props.addProperty("schemaid", this.id);
        return props;
    }

    public String getGroup() {
        return "persistence";
    }

    class CreateAccessTokenConsumer
    extends DefaultResponseConsumingStrategy {
        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 201) {
                String output = "Access token to bind application '" + GrantSchemaAccessCommand.this.grantedToParameter + "' to schema '" + GrantSchemaAccessCommand.this.id + "': " + context.getResponseContentString();
                System.out.println(output);
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

