/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractComponentCommand;
import com.sap.core.persistence.commands.entities.BindingInfoEntity;
import com.sap.core.persistence.commands.entities.BindingListResponseEntity;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Lists the data sources and their bindings to schemas and productive HANA instances for an application (deprecated: use 'list-application-datasources' instead).")
public class ListApplicationSchemasCommand
extends AbstractComponentCommand {
    static final String SCHEMA_ID_HEADER_LABEL = "Schema ID";
    static final String DB_TYPE_HEADER_LABEL = "DB Type";
    static final String DATASOURCE_HEADER_LABEL = "Data Source";
    static final String DB_USER_NAME_LABEL = "Database User";
    static final String LIST_APPLICATION_SCHEMAS_COMMAND_NAME = "list-application-schemas";

    public void init() throws CommandException {
        CheckHelper.checkAccountAndAppSpecified((String)this.getAccount(), (String)this.getApplication());
        super.init();
    }

    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return LIST_APPLICATION_SCHEMAS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListApplicationSchemasConsumer(), (ICommandTunnelCommand)this, "bindings/" + this.application + "/" + this.component);
        helper.executeRequest();
    }

    ListApplicationSchemasConsumer getNewListSchemaConsumer() {
        return new ListApplicationSchemasConsumer();
    }

    protected class ListApplicationSchemasConsumer
    extends JsonConsumingStrategy<BindingListResponseEntity> {
        private ListApplicationSchemasConsumer() {
            super(BindingListResponseEntity.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.printResult((BindingListResponseEntity)this.getJsonObject(context));
            } else {
                super.consume(context);
            }
        }

        void printResult(BindingListResponseEntity bindingList) {
            boolean showUserName = false;
            for (BindingInfoEntity bindingInfo : bindingList.bindingInfoList) {
                if (bindingInfo.getDbUserName() == null) continue;
                showUserName = true;
                break;
            }
            String[] headers = showUserName ? new String[]{ListApplicationSchemasCommand.SCHEMA_ID_HEADER_LABEL, ListApplicationSchemasCommand.DB_TYPE_HEADER_LABEL, ListApplicationSchemasCommand.DATASOURCE_HEADER_LABEL, ListApplicationSchemasCommand.DB_USER_NAME_LABEL} : new String[]{ListApplicationSchemasCommand.SCHEMA_ID_HEADER_LABEL, ListApplicationSchemasCommand.DB_TYPE_HEADER_LABEL, ListApplicationSchemasCommand.DATASOURCE_HEADER_LABEL};
            FormattedTable table = new FormattedTable(headers);
            for (BindingInfoEntity bindingInfo : bindingList.bindingInfoList) {
                if (showUserName) {
                    String dbUserName = bindingInfo.getDbUserName();
                    if (dbUserName == null) {
                        dbUserName = "";
                    }
                    table.addRow(new String[]{this.createSchemaID(bindingInfo), bindingInfo.databaseType, bindingInfo.dataSourceName, dbUserName});
                    continue;
                }
                table.addRow(new String[]{this.createSchemaID(bindingInfo), bindingInfo.databaseType, bindingInfo.dataSourceName});
            }
            table.printTo(System.out);
        }

        private String createSchemaID(BindingInfoEntity bindingInfo) {
            String schemaID = bindingInfo.getSchemaID();
            if (bindingInfo.getAccount() != null) {
                schemaID = bindingInfo.getAccount() + ":" + schemaID;
            }
            return schemaID;
        }
    }
}

