/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractDatabaseAccessPermissionsCommand;
import com.sap.core.persistence.commands.entities.DatabaseAccessPermissionsInfoEntity;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Parameters(commandDescription="Lists the permissions that other subaccounts have for accessing databases in the specified subaccount.")
public class ListDatabaseAccessPermissionsCommand
extends AbstractDatabaseAccessPermissionsCommand {
    private static final String LIST_DATABASE_ACCESS_COMMAND_NAME = "list-db-access-permissions";
    @Parameter(names={"-i", "--id"}, description="(Optional) Specify a database to view the permissions only to that database.", required=false)
    private String id;
    @Parameter(names={"--to-account"}, description="(Optional) Specify a subaccount to view the permissions only for that subaccount.", required=false)
    private String toAccount;
    @Parameter(names={"--permissions"}, description="(Optional) Filter the result by permission. Acceptable values: comma separated list of 'TUNNEL', 'BINDING'", required=false)
    private String permissionsParameter;
    List<AbstractDatabaseAccessPermissionsCommand.Permission> permissions = new ArrayList<AbstractDatabaseAccessPermissionsCommand.Permission>();

    public String getId() {
        return this.id;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public List<AbstractDatabaseAccessPermissionsCommand.Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    public void init() throws CommandException {
        super.init();
        if (this.permissionsParameter != null) {
            this.permissions.addAll(this.parsePermissionsParameter(this.permissionsParameter));
        }
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListDatabaseAccessPermissionConsumer(), (ICommandTunnelCommand)this, this.getRequestPath(this.getId(), this.getToAccount(), this.getPermissions()));
        helper.executeRequest();
    }

    public String getName() {
        return LIST_DATABASE_ACCESS_COMMAND_NAME;
    }

    public String getGroup() {
        return "persistence";
    }

    private static class ListDatabaseAccessPermissionConsumer
    extends JsonConsumingStrategy<DatabaseAccessPermissionsInfoEntity> {
        private static final String HEADER_DATABASE_ID = "Database ID";
        private static final String HEADER_ACCOUNT = "Subaccount";
        private static final String HEADER_PERMISSION = "Permission";
        private static final String HEADER_STATUS = "Status";

        public ListDatabaseAccessPermissionConsumer() {
            super(DatabaseAccessPermissionsInfoEntity.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 200) {
                List result = this.getJsonArray(context);
                this.sortResult(result);
                this.printResult(result);
            } else if (statusCode == 400 || statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }

        private void sortResult(List<DatabaseAccessPermissionsInfoEntity> result) {
            Collections.sort(result, new Comparator<DatabaseAccessPermissionsInfoEntity>(){

                @Override
                public int compare(DatabaseAccessPermissionsInfoEntity o1, DatabaseAccessPermissionsInfoEntity o2) {
                    int result = o1.getDatabaseId().compareTo(o2.getDatabaseId());
                    if (result == 0) {
                        result = o1.getTargetAccount().compareTo(o2.getTargetAccount());
                    }
                    return result;
                }
            });
        }

        private void printResult(List<DatabaseAccessPermissionsInfoEntity> entityList) {
            FormattedTable table = new FormattedTable(new String[]{HEADER_DATABASE_ID, HEADER_ACCOUNT, HEADER_PERMISSION, HEADER_STATUS});
            String previousDatabaseId = null;
            for (DatabaseAccessPermissionsInfoEntity info : entityList) {
                if (previousDatabaseId != null && !previousDatabaseId.equals(info.getDatabaseId())) {
                    previousDatabaseId = info.getDatabaseId();
                    table.addRow(new String[]{"", "", "", ""});
                } else if (previousDatabaseId == null) {
                    previousDatabaseId = info.getDatabaseId();
                }
                table.addRow(new String[]{info.getDatabaseId(), info.getTargetAccount(), info.getPermission(), info.getStatus()});
            }
            table.printTo(System.out);
        }
    }
}

