/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.DbmsInfoEntity;
import com.sap.core.persistence.commands.entities.DbmsInfoEntityComparator;
import com.sap.core.persistence.commands.util.DBTypeConversion;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists dedicated and shared database management systems available for a subaccount")
public class ListDbms
extends AbstractAccountCommand {
    static final String DB_TYPE_HEADER_LABEL = "DB Type";
    static final String DB_VERSION_HEADER_LABEL = "DB Version";
    static final String DB_SYSTEM_HEADER_LABEL = "DB System";
    static final String DEDICATED_DBMS_HEADER_LABEL = "Dedicated:";
    static final String SHARED_DBMS_HEADER_LABEL = "Shared:";
    static final String TRIAL_DBMS_HEADER_LABEL = "Trial:";
    public static final String LIST_DBMS_COMMAND_NAME = "list-dbms";

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return LIST_DBMS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListDbmsConsumer(), (ICommandTunnelCommand)this, "dbms/");
        helper.executeRequest();
    }

    protected class ListDbmsConsumer
    extends JsonConsumingStrategy<DbmsInfoEntity> {
        private ListDbmsConsumer() {
            super(DbmsInfoEntity.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                List resultArray = this.getJsonArray(context);
                Collections.sort(resultArray, new DbmsInfoEntityComparator());
                this.printResult(resultArray);
            } else {
                super.consume(context);
            }
        }

        void printResult(List<DbmsInfoEntity> dbmsInfoEntityList) {
            FormattedTable dedicatedDBMSTable = new FormattedTable(new String[]{ListDbms.DB_SYSTEM_HEADER_LABEL, ListDbms.DB_TYPE_HEADER_LABEL, ListDbms.DB_VERSION_HEADER_LABEL});
            FormattedTable sharedDBMSTable = new FormattedTable(new String[]{ListDbms.DB_TYPE_HEADER_LABEL, ListDbms.DB_VERSION_HEADER_LABEL});
            FormattedTable trialDBMSTable = new FormattedTable(new String[]{ListDbms.DB_TYPE_HEADER_LABEL});
            for (DbmsInfoEntity dbmsInfo : dbmsInfoEntityList) {
                if (dbmsInfo.isSharedSystem()) {
                    sharedDBMSTable.addRow(new String[]{DBTypeConversion.getDisplayName(dbmsInfo.getDbType()), dbmsInfo.getDisplayDbVersion()});
                    continue;
                }
                if (dbmsInfo.isTrialSystem()) {
                    trialDBMSTable.addRow(new String[]{DBTypeConversion.getDisplayName(dbmsInfo.getDbType())});
                    continue;
                }
                dedicatedDBMSTable.addRow(new String[]{dbmsInfo.getDbAliasName(), DBTypeConversion.getDisplayName(dbmsInfo.getDbType()), dbmsInfo.getDisplayDbVersion()});
            }
            if (!dedicatedDBMSTable.isEmpty()) {
                System.out.println(ListDbms.DEDICATED_DBMS_HEADER_LABEL);
                dedicatedDBMSTable.printTo(System.out);
            }
            System.out.println(ListDbms.SHARED_DBMS_HEADER_LABEL);
            sharedDBMSTable.printTo(System.out);
            if (!trialDBMSTable.isEmpty()) {
                System.out.println(ListDbms.TRIAL_DBMS_HEADER_LABEL);
                trialDBMSTable.printTo(System.out);
            }
        }
    }
}

