/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.persistence.commands.entities.DbsInfoEntityComparator;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists all databases for the specified subaccount")
public class ListDbsCommand
extends AbstractAccountCommand {
    @Parameter(names={"--verbose"}, description="verbose")
    private boolean verbose = false;
    static final String DB_ID_HEADER_LABEL = "Database ID";
    static final String DB_SYSTEM_HEADER_LABEL = "DB System";
    static final String DB_TYPE_HEADER_LABEL = "DB Type";
    static final String DB_VERSION_HEADER_LABEL = "DB Version";
    static final String DB_STATE_HEADER_LABEL = "DB State";
    public static final String LIST_DBS_COMMAND_NAME = "list-dbs";

    @Override
    public void cleanup() throws CommandException {
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return LIST_DBS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListDbsConsumer(), (ICommandTunnelCommand)this, "common/databases/");
        helper.executeRequest();
    }

    protected class ListDbsConsumer
    extends JsonConsumingStrategy<DbsInfoEntity> {
        private ListDbsConsumer() {
            super(DbsInfoEntity.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                List resultArray = this.getJsonArray(context);
                Collections.sort(resultArray, new DbsInfoEntityComparator());
                this.printResult(resultArray);
            } else {
                super.consume(context);
            }
        }

        void printResult(List<DbsInfoEntity> dbsInfoEntityList) {
            FormattedTable table;
            if (ListDbsCommand.this.verbose) {
                table = new FormattedTable(new String[]{ListDbsCommand.DB_ID_HEADER_LABEL, ListDbsCommand.DB_SYSTEM_HEADER_LABEL, ListDbsCommand.DB_TYPE_HEADER_LABEL, ListDbsCommand.DB_VERSION_HEADER_LABEL, ListDbsCommand.DB_STATE_HEADER_LABEL});
                for (DbsInfoEntity info : dbsInfoEntityList) {
                    table.addRow(new String[]{info.getDatabaseId(), info.getDbSystemName(), info.getDbType(), info.getDbVersion(), info.getDbState()});
                }
            } else {
                table = new FormattedTable(new String[]{ListDbsCommand.DB_ID_HEADER_LABEL});
                for (DbsInfoEntity info : dbsInfoEntityList) {
                    table.addRow(new String[]{info.getDatabaseId()});
                }
            }
            table.printTo(System.out);
        }
    }
}

