/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.SchemaAccessTokenResponse;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.List;

@Parameters(commandDescription="Lists all current schema access grants for a specified subaccount")
public class ListSchemaAccessGrantsCommand
extends AbstractAccountCommand {
    static final String TABLE_HEADER = "Schema Access Grants:";
    static final String ACCESSTOKEN_HEADER_LABEL = "Access Token";
    static final String SCHEMA_ID_HEADER_LABEL = "Schema ID";
    static final String GRANTED_TO_HEADER_LABEL = "Granted To";
    static final String BOUND_HEADER_LABEL = "Bound";
    static final String LIST_SCHEMA_ACCESS_GRANTS_COMMAND_NAME = "list-schema-access-grants";
    @Parameter(names={"-i", "--id"}, description="Database or schema ID. Starts with a letter and contains 'a' - 'z' and '0' - '9'. For schema IDs, 'A' - 'Z', '.' and '-' are also allowed.")
    private String id;

    public String getName() {
        return LIST_SCHEMA_ACCESS_GRANTS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        String psaApiPath = "accesstokens/";
        if (this.id != null) {
            psaApiPath = psaApiPath + HttpClientProvider.encodeURLString((String)this.id);
        }
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListSchemaAccessTokenConsumer(), (ICommandTunnelCommand)this, psaApiPath);
        helper.executeRequest();
    }

    public String getGroup() {
        return "persistence";
    }

    protected class ListSchemaAccessTokenConsumer
    extends JsonConsumingStrategy<SchemaAccessTokenResponse> {
        private ListSchemaAccessTokenConsumer() {
            super(SchemaAccessTokenResponse.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.printResult(this.getJsonArray(context));
            } else {
                super.consume(context);
            }
        }

        void printResult(List<SchemaAccessTokenResponse> responseList) {
            FormattedTable table = new FormattedTable(new String[]{ListSchemaAccessGrantsCommand.ACCESSTOKEN_HEADER_LABEL, ListSchemaAccessGrantsCommand.SCHEMA_ID_HEADER_LABEL, ListSchemaAccessGrantsCommand.GRANTED_TO_HEADER_LABEL, ListSchemaAccessGrantsCommand.BOUND_HEADER_LABEL});
            for (SchemaAccessTokenResponse satr : responseList) {
                String grantedTo = satr.getToAccount() + ":" + satr.getToApplication();
                String isBound = satr.isSchemaBound() ? "yes" : "no";
                table.addRow(new String[]{satr.getAccessToken(), satr.getSchemaId(), grantedTo, isBound});
            }
            System.out.println(ListSchemaAccessGrantsCommand.TABLE_HEADER);
            table.printTo(System.out);
        }
    }
}

