/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.Schema;
import com.sap.core.persistence.commands.entities.SchemasForAccount;
import com.sap.core.persistence.commands.util.DBTypeConversion;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.core.tunnelcommands.util.FormattedTable;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Lists schemas of a subaccount")
public class ListSchemas
extends AbstractAccountCommand {
    static final String SCHEMA_ID_HEADER_LABEL = "Schema ID";
    static final String DB_TYPE_HEADER_LABEL = "DB Type";
    static final String DB_VERSION_HEADER_LABEL = "DB Version";
    static final String DB_SYSTEM_HEADER_LABEL = "DB System";
    public static final String LIST_SCHEMAS_COMMAND_NAME = "list-schemas";
    @Parameter(names={"--verbose"}, description="verbose")
    private boolean verbose = false;

    @Override
    public void cleanup() throws CommandException {
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return LIST_SCHEMAS_COMMAND_NAME;
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)new ListSchemaConsumer(), (ICommandTunnelCommand)this, "schemas/");
        helper.executeRequest();
    }

    ListSchemaConsumer getNewListSchemaConsumer() {
        return new ListSchemaConsumer();
    }

    protected class ListSchemaConsumer
    extends JsonConsumingStrategy<SchemasForAccount> {
        private ListSchemaConsumer() {
            super(SchemasForAccount.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.printResult((SchemasForAccount)this.getJsonObject(context));
            } else {
                super.consume(context);
            }
        }

        void printResult(SchemasForAccount schemasForAccount) {
            Schema[] schemas = schemasForAccount.getSchemas();
            FormattedTable table = ListSchemas.this.verbose ? new FormattedTable(new String[]{ListSchemas.SCHEMA_ID_HEADER_LABEL, ListSchemas.DB_TYPE_HEADER_LABEL, ListSchemas.DB_SYSTEM_HEADER_LABEL, ListSchemas.DB_VERSION_HEADER_LABEL}) : new FormattedTable(new String[]{ListSchemas.SCHEMA_ID_HEADER_LABEL});
            for (Schema schema : schemas) {
                if (ListSchemas.this.verbose) {
                    table.addRow(new String[]{schema.getSchemaId(), DBTypeConversion.getDisplayName(schema.getDbType()), schema.getDisplayDBSystemName(), schema.getDisplayDBVersion()});
                    continue;
                }
                table.addRow(new String[]{schema.getSchemaId()});
            }
            table.printTo(System.out);
        }

        int findMaxLengthForSchemaId(Schema[] testSchemas, int minLength) {
            int maxLength = minLength;
            for (Schema schema : testSchemas) {
                if (schema.getSchemaId().length() <= maxLength) continue;
                maxLength = schema.getSchemaId().length();
            }
            return maxLength;
        }
    }
}

