/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpPostStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Restarts a HANA Instance or HANA Service. Applicable for dedicated database systems only.")
public class RestartHana
extends AbstractAccountCommand {
    static final String HANA_RESTART_COMMAND_NAME = "restart-hana";
    @Parameter(names={"--service-name"}, description="Service to be restarted.")
    private String serviceParameter;
    @Parameter(names={"--system"}, description="Specifies if the whole system should be restarted.")
    private boolean isSystemParameterSet = false;
    @Parameter(names={"-i", "--id"}, description="HANA instance ID")
    private String idParameter;

    @Override
    public void init() throws CommandException {
        super.init();
        this.checkArgs();
    }

    private void checkArgs() {
        this.checkParametersCollision();
        this.checkServiceNameOrSystemIsPresent();
        this.checkHanaInstanceId();
    }

    private void checkHanaInstanceId() {
        CheckHelper.checkArgSpecified((String)"--id", (String)"-i", (String)this.idParameter);
    }

    private void checkServiceNameOrSystemIsPresent() {
        if (!this.isServiceParameterSet() && !this.isSystemParameterSet) {
            throw new ParameterException("--service-name or --system parameter must be specified");
        }
    }

    private void checkParametersCollision() {
        if (this.isServiceParameterSet() && this.isSystemParameterSet) {
            throw new ParameterException("Parameters --service-name and --system are mutually exclusive and must not be specified together.");
        }
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return HANA_RESTART_COMMAND_NAME;
    }

    public void run() throws CommandException {
        if (this.isServiceParameterSet()) {
            String urlCommandPrefix = "restarthana/service/" + HttpClientProvider.encodeURLString((String)this.serviceParameter);
            this.executeCommand(new RestartServiceConsumer(), urlCommandPrefix);
        } else if (this.isSystemParameterSet) {
            this.executeCommand(new RestartSystemConsumer(), "restarthana/system");
        }
    }

    private boolean isServiceParameterSet() {
        return this.serviceParameter != null && !this.serviceParameter.trim().isEmpty();
    }

    private void executeCommand(RestartHanaConsumer consumer, String urlCommandPrefix) {
        HttpPostStrategy restCallStrategy = new HttpPostStrategy();
        String commandUrl = urlCommandPrefix + "/dbsystem/" + HttpClientProvider.encodeURLString((String)this.idParameter);
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)consumer, (ICommandTunnelCommand)this, commandUrl);
        helper.executeRequest();
    }

    private static class RestartHanaConsumer
    extends DefaultResponseConsumingStrategy {
        private String successMessage;
        private String errorMessage;

        public RestartHanaConsumer(String successMessage, String errorMessage) {
            this.successMessage = successMessage;
            this.errorMessage = errorMessage;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            switch (statusCode) {
                case 200: {
                    System.out.println(this.successMessage);
                    break;
                }
                case 400: {
                    super.throwCommandExceptionWithContentInfoAndLog(this.errorMessage, context);
                    break;
                }
                case 409: {
                    System.out.println(context.getResponseContentString());
                    break;
                }
                default: {
                    super.consume(context);
                }
            }
        }
    }

    private static class RestartSystemConsumer
    extends RestartHanaConsumer {
        public RestartSystemConsumer() {
            this("Request to restart system accepted. You can monitor the system status using Configuration and Monitoring -> Open Administration in SAP HANA Studio", "System restart request failed.");
        }

        public RestartSystemConsumer(String successMessage, String errorMessage) {
            super(successMessage, errorMessage);
        }
    }

    private static class RestartServiceConsumer
    extends RestartHanaConsumer {
        public RestartServiceConsumer() {
            this("Request to restart service accepted.", "Service restart request failed.");
        }

        public RestartServiceConsumer(String successMessage, String errorMessage) {
            super(successMessage, errorMessage);
        }
    }
}

