/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractDatabaseAccessPermissionsCommand;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.List;

@Parameters(commandDescription="Revokes the database access permissions given to another subaccount.")
public class RevokeDatabaseAccessCommand
extends AbstractDatabaseAccessPermissionsCommand {
    private static final String REVOKE_DATABASE_ACCESS_COMMAND_NAME = "revoke-db-access";
    @Parameter(names={"-i", "--id"}, description="ID of the database to which access will be revoked.")
    private String id;
    @Parameter(names={"--to-account"}, description="The subaccount from which access permissions will be revoked.")
    private String toAccount;
    @Parameter(names={"--permissions"}, description="Comma-separated list of the permissions to be revoked. Acceptable values: 'TUNNEL',  'BINDING'.")
    private String permissionsParameter;
    private List<AbstractDatabaseAccessPermissionsCommand.Permission> permissions = new ArrayList<AbstractDatabaseAccessPermissionsCommand.Permission>();

    public String getId() {
        return this.id;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public List<AbstractDatabaseAccessPermissionsCommand.Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    public void init() throws CommandException {
        super.init();
        this.checkDatabaseIdSpecified(this.id);
        this.checkToAccountSpecified(this.toAccount);
        this.checkPermissionsSpecified(this.permissionsParameter);
        this.permissions.addAll(this.parsePermissionsParameter(this.permissionsParameter));
    }

    public void run() throws CommandException {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpDeleteStrategy(), (HttpResponseConsumingStrategy)new GrantDatabaseAccessConsumer(), (ICommandTunnelCommand)this, this.getRequestPath(this.getId(), this.getToAccount(), this.getPermissions()));
        helper.executeRequest();
    }

    public String getName() {
        return REVOKE_DATABASE_ACCESS_COMMAND_NAME;
    }

    public String getGroup() {
        return "persistence";
    }

    private static class GrantDatabaseAccessConsumer
    extends DefaultResponseConsumingStrategy {
        private static final String SUCCESS_MESSAGE = "Request to revoke permissions sent. The change may take a few minutes. Use list-db-access-permissions to check the outcome.";
        private static final String NOT_MODIFIED_MESSAGE = "The permission does not exist.";

        private GrantDatabaseAccessConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 202) {
                System.out.println(SUCCESS_MESSAGE);
            } else if (statusCode == 304) {
                System.out.println(NOT_MODIFIED_MESSAGE);
            } else if (statusCode == 400 || statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

