/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.AbstractAccountCommand;
import com.sap.core.persistence.commands.entities.SchemaAccessTokenResponse;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.io.Console;

@Parameters(commandDescription="Revokes the schema access granted to an application in another subaccount")
public class RevokeSchemaAccessCommand
extends AbstractAccountCommand {
    static final String REVOKE_SCHEMA_ACCESS_COMMAND_NAME = "revoke-schema-access";
    @Parameter(names={"--access-token"}, description="Access token that identifies the grant")
    private String accessToken;
    @Parameter(names={"--silent"}, description="(optional) Suppresses the command line confirmation prompt")
    private boolean silent = false;

    public String getName() {
        return REVOKE_SCHEMA_ACCESS_COMMAND_NAME;
    }

    @Override
    public void init() throws CommandException {
        this.checkArgID();
        super.init();
    }

    public void checkArgID() {
        CheckHelper.checkArgSpecified(null, (String)"--access-token", (String)this.accessToken);
    }

    public void run() throws CommandException {
        if (!this.silent && !this.userConfirm()) {
            throw new CommandException("User declined the revoke.", 50);
        }
        this.executeRevokeSchemaAccess();
    }

    private boolean userConfirm() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console available. Please use parameter --silent to force the deletion without console.", 167);
        }
        System.out.println("Are you sure you want to revoke the schema access token? (yes/no) ");
        String answer = cons.readLine().toLowerCase();
        return "yes".equals(answer) || "y".equals(answer);
    }

    private void executeRevokeSchemaAccess() {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpDeleteStrategy(), (HttpResponseConsumingStrategy)new RevokeSchemaAccessConsumer(), (ICommandTunnelCommand)this, "accesstoken/" + HttpClientProvider.encodeURLString((String)this.accessToken));
        helper.executeRequest();
    }

    public String getGroup() {
        return "persistence";
    }

    class RevokeSchemaAccessConsumer
    extends JsonConsumingStrategy<SchemaAccessTokenResponse> {
        private RevokeSchemaAccessConsumer() {
            super(SchemaAccessTokenResponse.class);
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            if (statusCode == 200) {
                SchemaAccessTokenResponse response = (SchemaAccessTokenResponse)this.getJsonObject(context);
                String schemaId = response.getSchemaId();
                String application = response.getToAccount() + ":" + response.getToApplication();
                String out = "Access to schema '" + schemaId + "' from application '" + application + "' revoked.";
                System.out.println(out);
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog("Could not revoke schema access token.", context);
            } else {
                super.consume(context);
            }
        }
    }
}

