/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.ase;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.persistence.commands.ase.AbstractCommandWithDBId;
import java.io.Console;

public abstract class AbstractCommandWithDBPassword
extends AbstractCommandWithDBId {
    @Parameter(names={"--db-password"}, description="The password of the user for the ASE database (optional, queried at the command prompt if omitted).", required=false)
    protected String dbPasswordParameter;

    protected void checkPassword() {
        if (this.dbPasswordParameter == null || this.dbPasswordParameter.trim().isEmpty()) {
            this.getPassword();
            String passwordRepeated = null;
            Console cons = System.console();
            if (cons != null) {
                char[] passwd2;
                char[] passwd1 = cons.readPassword("%s", "Password for ASE database user: ");
                if (passwd1 != null && passwd1.length > 0) {
                    this.dbPasswordParameter = new String(passwd1);
                }
                if ((passwd2 = cons.readPassword("%s", "Repeat password for ASE database user: ")) != null && passwd2.length > 0) {
                    passwordRepeated = new String(passwd2);
                }
            }
            if (this.dbPasswordParameter == null || this.dbPasswordParameter.trim().isEmpty()) {
                throw new ParameterException(" Empty passwords are not recommended. You can also use the '--db-password' option on the commandline to specify a password.");
            }
            if (!this.dbPasswordParameter.equals(passwordRepeated)) {
                throw new ParameterException("The password and the repeated password must be identical.");
            }
        }
    }
}

