/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.ase;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.ase.AbstractCommandWithDBPassword;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Creates an ASE database with the specified ID and settings on an ASE database system.")
public class CreateDatabaseCommand
extends AbstractCommandWithDBPassword {
    private static final String CREATE_DATABASE = "create-db-ase";
    @Parameter(names={"--dbsystem"}, description="ID of a productive ASE database system", required=true)
    private String dbSystemParameter;
    @Parameter(names={"--db-user"}, description="The name of the database user to access the database", required=true)
    private String dbUserParameter;
    @Parameter(names={"--db-size"}, description="Size of the database to be created in MB.", required=true)
    private String dbSizeParameter;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        this.checkArgDbSystem();
        this.checkArgDbUser();
        this.checkArgDbSize();
        super.init();
    }

    private void checkArgDbSystem() {
        CheckHelper.checkArgSpecified((String)"--dbsystem", (String)"--dbsystem", (String)this.dbSystemParameter);
    }

    private void checkArgDbUser() {
        CheckHelper.checkArgSpecified((String)"--db-user", (String)"--db-user", (String)this.dbUserParameter);
    }

    private void checkArgDbSize() {
        CheckHelper.checkArgSpecified((String)"--db-size", (String)"--db-size", (String)this.dbSizeParameter);
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return CREATE_DATABASE;
    }

    public void run() throws CommandException {
        this.checkPassword();
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new CreateDatabaseConsumer(), (ICommandTunnelCommand)this, "ase/databases/" + HttpClientProvider.encodeURLString((String)this.databaseId));
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        props.addProperty("dbSystem", this.dbSystemParameter);
        props.addProperty("dbUser", this.dbUserParameter);
        props.addProperty("dbPassword", this.dbPasswordParameter);
        props.addProperty("dbSizeInMB", this.dbSizeParameter);
        return props;
    }

    private class CreateDatabaseConsumer
    extends DefaultResponseConsumingStrategy {
        private CreateDatabaseConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 201) {
                System.out.println("ASE database '" + CreateDatabaseCommand.this.databaseId + "' created.");
            } else if (statusCode == 202) {
                System.out.println("Request to create ASE database '" + CreateDatabaseCommand.this.databaseId + "' as part of ASE system '" + CreateDatabaseCommand.this.dbSystemParameter + "' is accepted. The request will be processed asynchronously. To check the status of this request you may use display-db-info command.");
            } else if (statusCode == 409 || statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

