/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.ase;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.JsonObject;
import com.sap.core.persistence.commands.ase.AbstractCommandWithDBPassword;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpPutStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;

@Parameters(commandDescription="Creates a user for an ASE database.")
public class CreateUserCommand
extends AbstractCommandWithDBPassword {
    private static final String CREATE_DATABASE_USER = "create-db-user-ase";
    @Parameter(names={"--db-user"}, description="The name of the database user to access the database", required=true)
    private String dbUserParameter;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        this.checkArgDbUser();
        super.init();
    }

    private void checkArgDbUser() {
        CheckHelper.checkArgSpecified((String)"--db-user", (String)"--db-user", (String)this.dbUserParameter);
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return CREATE_DATABASE_USER;
    }

    public void run() throws CommandException {
        this.checkPassword();
        HttpPutStrategy restCallStrategy = new HttpPutStrategy(this.getCommandParamsAsJson());
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new CreateDatabaseUserConsumer(), (ICommandTunnelCommand)this, "ase/databases/" + HttpClientProvider.encodeURLString((String)this.databaseId) + "/users/" + HttpClientProvider.encodeURLString((String)this.dbUserParameter));
        helper.executeRequest();
    }

    private JsonObject getCommandParamsAsJson() {
        JsonObject props = new JsonObject();
        props.addProperty("dbPassword", this.dbPasswordParameter);
        return props;
    }

    private class CreateDatabaseUserConsumer
    extends DefaultResponseConsumingStrategy {
        private CreateDatabaseUserConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 201) {
                System.out.println("ASE user '" + CreateUserCommand.this.dbUserParameter + "' created.");
            } else if (statusCode == 409 || statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

