/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.ase;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.ase.AbstractCommandWithDBId;
import com.sap.core.persistence.commands.entities.DbTunnelAccessTokenResponse;
import com.sap.core.persistence.commands.entities.DbsInfoEntity;
import com.sap.core.tunnelcommands.framework.executor.CommandExecutionContext;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpGetStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.core.tunnelcommands.framework.executor.JsonConsumingStrategy;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.Console;
import java.util.List;

@Parameters(commandDescription="Deletes the ASE database with the specified ID.")
public class DeleteDatabaseCommand
extends AbstractCommandWithDBId {
    private static final String DELETE_DATABASE = "delete-db-ase";
    @Parameter(names={"-f", "--force"}, description="(optional) Forcefully deletes the ASE database, including all application bindings.", required=false)
    private boolean forceParameter = false;
    @Parameter(names={"--silent"}, description="(optional) Suppresses the command line confirmation prompt", required=false)
    private boolean silent = false;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        super.init();
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return DELETE_DATABASE;
    }

    public void run() throws CommandException {
        CommandExecutionContext context = new CommandExecutionContext();
        if (this.silent || this.userConfirm()) {
            if (this.forceParameter || this.isDeletionAllowed(context)) {
                this.executeDeleteDatabase(context);
            }
        } else {
            throw new CommandException("User declined the deletion.", 50);
        }
    }

    private void executeDeleteDatabase(CommandExecutionContext context) {
        HttpDeleteStrategy restCallStrategy = new HttpDeleteStrategy();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)restCallStrategy, (HttpResponseConsumingStrategy)new DeleteDatabaseConsumer(), (ICommandTunnelCommand)this, "ase/databases/" + HttpClientProvider.encodeURLString((String)this.databaseId));
        helper.executeRequest();
    }

    private boolean userConfirm() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console available. Please use parameter --silent to force the deletion without console.", 167);
        }
        System.out.println("Are you sure you want to delete the ASE database '" + this.databaseId + "' permanently? This operation cannot be reverted. (yes/no) ");
        String answer = cons.readLine();
        return "yes".equalsIgnoreCase(answer) || "y".equalsIgnoreCase(answer);
    }

    private boolean isDeletionAllowed(CommandExecutionContext context) {
        CheckIfBindingsExistConsumer bindingConsumer = new CheckIfBindingsExistConsumer();
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)bindingConsumer, (ICommandTunnelCommand)this, "common/databases/" + HttpClientProvider.encodeURLString((String)this.databaseId));
        helper.executeRequest();
        if (bindingConsumer.isExistBindings()) {
            return false;
        }
        CheckIfDbTunnelAccessTokensExistConsumer accessTokenConsumer = new CheckIfDbTunnelAccessTokensExistConsumer();
        helper = new CommandTunnelRequestExecutor(context, (HttpUriRequestStrategy)new HttpGetStrategy(), (HttpResponseConsumingStrategy)accessTokenConsumer, (ICommandTunnelCommand)this, "dbtunnelaccesstokens/" + HttpClientProvider.encodeURLString((String)this.databaseId));
        helper.executeRequest();
        return !accessTokenConsumer.isExistTokens();
    }

    private class CheckIfDbTunnelAccessTokensExistConsumer
    extends JsonConsumingStrategy<DbTunnelAccessTokenResponse> {
        private Boolean isExistTokens;

        public CheckIfDbTunnelAccessTokensExistConsumer() {
            super(DbTunnelAccessTokenResponse.class);
            this.isExistTokens = null;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            if (statusCode == 200) {
                this.determineIfDeletionAllowed(this.getJsonArray(context));
            } else if (statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, null, context, "ASE database '" + DeleteDatabaseCommand.this.databaseId + "' doesn't exist.");
            } else {
                super.consume(context);
            }
        }

        private void determineIfDeletionAllowed(List<DbTunnelAccessTokenResponse> responseList) {
            if (responseList == null || responseList.size() == 0) {
                this.isExistTokens = false;
                return;
            }
            String message = "ASE database '" + DeleteDatabaseCommand.this.databaseId + "' cannot be deleted because there are still existing db tunnel access tokens. Remove them all before deleting the database or use the " + "--force" + " parameter.";
            System.out.println(message);
            this.isExistTokens = true;
        }

        private boolean isExistTokens() {
            return this.isExistTokens;
        }
    }

    private class CheckIfBindingsExistConsumer
    extends JsonConsumingStrategy<DbsInfoEntity> {
        private Boolean isExistBindings;

        public CheckIfBindingsExistConsumer() {
            super(DbsInfoEntity.class);
            this.isExistBindings = null;
        }

        public void consume(HttpResponseContext context) throws CommandException {
            if (context.getStatusCode() == 200) {
                this.determineIfDeletionAllowed((DbsInfoEntity)this.getJsonObject(context));
            } else if (context.getStatusCode() == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, null, context, "ASE database '" + DeleteDatabaseCommand.this.databaseId + "' doesn't exist.");
            } else {
                super.consume(context);
            }
        }

        private void determineIfDeletionAllowed(DbsInfoEntity dbsInfo) {
            if (dbsInfo.getBindings() == null || dbsInfo.getBindings().length == 0) {
                this.isExistBindings = false;
                return;
            }
            String message = "ASE database '" + DeleteDatabaseCommand.this.databaseId + "' cannot be deleted because there are still bindings to it. Unbind all the applications before deleting the database or use the " + "--force" + " parameter.";
            System.out.println(message);
            this.isExistBindings = true;
        }

        private boolean isExistBindings() {
            return this.isExistBindings;
        }
    }

    private class DeleteDatabaseConsumer
    extends DefaultResponseConsumingStrategy {
        private DeleteDatabaseConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 200) {
                System.out.println("ASE database '" + DeleteDatabaseCommand.this.databaseId + "' deleted.");
            } else if (statusCode == 202) {
                System.out.println("Request to delete ASE database '" + DeleteDatabaseCommand.this.databaseId + "' is accepted. The request will be processed asynchronously. To check the status of this request you may use display-db-info command.");
            } else if (statusCode == 409 || statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else {
                super.consume(context);
            }
        }
    }
}

