/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.persistence.commands.ase;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.persistence.commands.ase.AbstractCommandWithDBId;
import com.sap.core.tunnelcommands.framework.executor.CommandTunnelRequestExecutor;
import com.sap.core.tunnelcommands.framework.executor.DefaultResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpClientProvider;
import com.sap.core.tunnelcommands.framework.executor.HttpDeleteStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseConsumingStrategy;
import com.sap.core.tunnelcommands.framework.executor.HttpResponseContext;
import com.sap.core.tunnelcommands.framework.executor.HttpUriRequestStrategy;
import com.sap.core.tunnelcommands.framework.executor.ICommandTunnelCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.Console;

@Parameters(commandDescription="Deletes a user from an ASE database.")
public class DeleteUserCommand
extends AbstractCommandWithDBId {
    private static final String DELETE_DATABASE_USER = "delete-db-user-ase";
    @Parameter(names={"--db-user"}, description="User ID", required=true)
    private String dbUserParameter;
    @Parameter(names={"--silent"}, description="(optional) Suppresses the command line confirmation prompt", required=false)
    private boolean silent = false;

    @Override
    public void init() throws CommandException {
        this.checkArgAccount();
        this.checkArgId();
        super.init();
    }

    public String getGroup() {
        return "persistence";
    }

    public String getName() {
        return DELETE_DATABASE_USER;
    }

    public void run() throws CommandException {
        if (!this.silent && !this.userConfirm()) {
            throw new CommandException("User declined the deletion.", 50);
        }
        this.executeDeleteUser();
    }

    private void executeDeleteUser() {
        CommandTunnelRequestExecutor helper = new CommandTunnelRequestExecutor((HttpUriRequestStrategy)new HttpDeleteStrategy(), (HttpResponseConsumingStrategy)new DeleteUserConsumer(), (ICommandTunnelCommand)this, "ase/databases/" + HttpClientProvider.encodeURLString((String)this.databaseId) + "/users/" + HttpClientProvider.encodeURLString((String)this.dbUserParameter));
        helper.executeRequest();
    }

    private boolean userConfirm() {
        Console cons = System.console();
        if (cons == null) {
            throw new CommandException("No console available. Please use parameter --silent to force the deletion without console.", 167);
        }
        System.out.println("Are you sure you want to delete this database user? (yes/no) ");
        String answer = cons.readLine();
        return "yes".equalsIgnoreCase(answer) || "y".equalsIgnoreCase(answer);
    }

    class DeleteUserConsumer
    extends DefaultResponseConsumingStrategy {
        DeleteUserConsumer() {
        }

        public void consume(HttpResponseContext context) throws CommandException {
            int statusCode = context.getStatusCode();
            if (statusCode == 200) {
                System.out.println("ASE user '" + DeleteUserCommand.this.dbUserParameter + "' deleted.");
            } else if (statusCode == 404) {
                this.throwCommandExceptionWithContentInfoAndLog(null, context);
            } else if (statusCode == 400) {
                this.throwCommandExceptionWithContentInfoAndLog("Could not delete user '" + DeleteUserCommand.this.dbUserParameter + "'.", context);
            } else {
                super.consume(context);
            }
        }
    }
}

